/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.client.api.edm.xml.v4.Annotatable;
import org.apache.olingo.client.api.edm.xml.v4.Annotation;
import org.apache.olingo.client.core.edm.EdmAnnotationImpl;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.core.edm.EdmAnnotationHelper;

public class EdmAnnotationHelperImpl
implements EdmAnnotationHelper {
    private final Edm edm;
    private final Annotatable annotatable;
    private List<EdmAnnotation> annotations;

    public EdmAnnotationHelperImpl(Edm edm, Annotatable annotatable) {
        this.edm = edm;
        this.annotatable = annotatable;
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        EdmAnnotation result = null;
        for (EdmAnnotation annotation : this.getAnnotations()) {
            if (!term.getFullQualifiedName().equals((Object)annotation.getTerm().getFullQualifiedName())) continue;
            result = annotation;
        }
        return result;
    }

    public List<EdmAnnotation> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new ArrayList<EdmAnnotation>();
            for (Annotation annotation : this.annotatable.getAnnotations()) {
                this.annotations.add(new EdmAnnotationImpl(this.edm, annotation));
            }
        }
        return this.annotations;
    }
}

