/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.client.api.edm.xml.v4.Annotatable;
import org.apache.olingo.client.api.edm.xml.v4.Annotation;
import org.apache.olingo.client.api.edm.xml.v4.annotation.AnnotationExpression;
import org.apache.olingo.client.api.edm.xml.v4.annotation.DynamicAnnotationExpression;
import org.apache.olingo.client.api.edm.xml.v4.annotation.PropertyValue;
import org.apache.olingo.client.core.edm.EdmAnnotationHelperImpl;
import org.apache.olingo.client.core.edm.v4.annotation.EdmCastImpl;
import org.apache.olingo.client.core.edm.v4.annotation.EdmConstantAnnotationExpressionImpl;
import org.apache.olingo.client.core.edm.v4.annotation.EdmIsOfImpl;
import org.apache.olingo.client.core.edm.v4.annotation.EdmRecordImpl;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotatable;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.annotation.EdmAnnotationExpression;
import org.apache.olingo.commons.api.edm.annotation.EdmDynamicAnnotationExpression;
import org.apache.olingo.commons.api.edm.annotation.EdmPropertyValue;
import org.apache.olingo.commons.core.edm.EdmAnnotationHelper;
import org.apache.olingo.commons.core.edm.annotation.EdmAndImpl;
import org.apache.olingo.commons.core.edm.annotation.EdmAnnotationPathImpl;
import org.apache.olingo.commons.core.edm.annotation.EdmApplyImpl;
import org.apache.olingo.commons.core.edm.annotation.EdmCollectionImpl;
import org.apache.olingo.commons.core.edm.annotation.EdmEqImpl;
import org.apache.olingo.commons.core.edm.annotation.EdmGeImpl;
import org.apache.olingo.commons.core.edm.annotation.EdmGtImpl;
import org.apache.olingo.commons.core.edm.annotation.EdmIfImpl;
import org.apache.olingo.commons.core.edm.annotation.EdmLabeledElementImpl;
import org.apache.olingo.commons.core.edm.annotation.EdmLabeledElementReferenceImpl;
import org.apache.olingo.commons.core.edm.annotation.EdmLeImpl;
import org.apache.olingo.commons.core.edm.annotation.EdmLtImpl;
import org.apache.olingo.commons.core.edm.annotation.EdmNavigationPropertyPathImpl;
import org.apache.olingo.commons.core.edm.annotation.EdmNeImpl;
import org.apache.olingo.commons.core.edm.annotation.EdmNotImpl;
import org.apache.olingo.commons.core.edm.annotation.EdmNullImpl;
import org.apache.olingo.commons.core.edm.annotation.EdmOrImpl;
import org.apache.olingo.commons.core.edm.annotation.EdmPathImpl;
import org.apache.olingo.commons.core.edm.annotation.EdmPropertyPathImpl;
import org.apache.olingo.commons.core.edm.annotation.EdmPropertyValueImpl;
import org.apache.olingo.commons.core.edm.annotation.EdmUrlRefImpl;

public class EdmAnnotationImpl
implements EdmAnnotation {
    private final Edm edm;
    private final Annotation annotation;
    private final EdmAnnotationHelper helper;
    private EdmTerm term;
    private EdmAnnotationExpression expression;

    public EdmAnnotationImpl(Edm edm, Annotation annotation) {
        this.edm = edm;
        this.annotation = annotation;
        this.helper = new EdmAnnotationHelperImpl(edm, (Annotatable)annotation);
    }

    public EdmTerm getTerm() {
        if (this.term == null) {
            this.term = this.edm.getTerm(new FullQualifiedName(this.annotation.getTerm()));
        }
        return this.term;
    }

    public String getQualifier() {
        return this.annotation.getQualifier();
    }

    private EdmAnnotationExpression getExpression(AnnotationExpression exp) {
        EdmConstantAnnotationExpressionImpl _expression = null;
        if (exp.isConstant()) {
            _expression = new EdmConstantAnnotationExpressionImpl(this.edm, exp.asConstant());
        } else if (this.annotation.getExpression().isDynamic()) {
            _expression = this.getDynamicExpression(exp.asDynamic());
        }
        return _expression;
    }

    private EdmDynamicAnnotationExpression getDynamicExpression(DynamicAnnotationExpression exp) {
        Object _expression = null;
        if (exp.isNot()) {
            _expression = new EdmNotImpl(this.getDynamicExpression(exp.asNot().getExpression()));
        } else if (exp.isTwoParamsOp()) {
            switch (exp.asTwoParamsOp().getType()) {
                case And: {
                    _expression = new EdmAndImpl(this.getDynamicExpression(exp.asTwoParamsOp().getLeftExpression()), this.getDynamicExpression(exp.asTwoParamsOp().getRightExpression()));
                    break;
                }
                case Or: {
                    _expression = new EdmOrImpl(this.getDynamicExpression(exp.asTwoParamsOp().getLeftExpression()), this.getDynamicExpression(exp.asTwoParamsOp().getRightExpression()));
                    break;
                }
                case Eq: {
                    _expression = new EdmEqImpl(this.getDynamicExpression(exp.asTwoParamsOp().getLeftExpression()), this.getDynamicExpression(exp.asTwoParamsOp().getRightExpression()));
                    break;
                }
                case Ne: {
                    _expression = new EdmNeImpl(this.getDynamicExpression(exp.asTwoParamsOp().getLeftExpression()), this.getDynamicExpression(exp.asTwoParamsOp().getRightExpression()));
                    break;
                }
                case Ge: {
                    _expression = new EdmGeImpl(this.getDynamicExpression(exp.asTwoParamsOp().getLeftExpression()), this.getDynamicExpression(exp.asTwoParamsOp().getRightExpression()));
                    break;
                }
                case Gt: {
                    _expression = new EdmGtImpl(this.getDynamicExpression(exp.asTwoParamsOp().getLeftExpression()), this.getDynamicExpression(exp.asTwoParamsOp().getRightExpression()));
                    break;
                }
                case Le: {
                    _expression = new EdmLeImpl(this.getDynamicExpression(exp.asTwoParamsOp().getLeftExpression()), this.getDynamicExpression(exp.asTwoParamsOp().getRightExpression()));
                    break;
                }
                case Lt: {
                    _expression = new EdmLtImpl(this.getDynamicExpression(exp.asTwoParamsOp().getLeftExpression()), this.getDynamicExpression(exp.asTwoParamsOp().getRightExpression()));
                    break;
                }
            }
        } else if (exp.isAnnotationPath()) {
            _expression = new EdmAnnotationPathImpl(exp.asAnnotationPath().getValue());
        } else if (exp.isApply()) {
            ArrayList<EdmAnnotationExpression> parameters = new ArrayList<EdmAnnotationExpression>(exp.asApply().getParameters().size());
            for (AnnotationExpression param : exp.asApply().getParameters()) {
                parameters.add(this.getExpression(param));
            }
            _expression = new EdmApplyImpl(exp.asApply().getFunction(), parameters);
        } else if (exp.isCast()) {
            _expression = new EdmCastImpl(this.edm, exp.asCast(), this.getDynamicExpression(exp.asCast().getValue()));
        } else if (exp.isCollection()) {
            ArrayList<EdmAnnotationExpression> items = new ArrayList<EdmAnnotationExpression>(exp.asCollection().getItems().size());
            for (AnnotationExpression param : exp.asCollection().getItems()) {
                items.add(this.getExpression(param));
            }
            _expression = new EdmCollectionImpl(items);
        } else if (exp.isIf()) {
            _expression = new EdmIfImpl(this.getExpression(exp.asIf().getGuard()), this.getExpression(exp.asIf().getThen()), this.getExpression(exp.asIf().getElse()));
        } else if (exp.isIsOf()) {
            _expression = new EdmIsOfImpl(this.edm, exp.asIsOf(), this.getDynamicExpression(exp.asIsOf().getValue()));
        } else if (exp.isLabeledElement()) {
            _expression = new EdmLabeledElementImpl(exp.asLabeledElement().getName(), this.getDynamicExpression(exp.asLabeledElement().getValue()));
        } else if (exp.isLabeledElementReference()) {
            _expression = new EdmLabeledElementReferenceImpl(exp.asLabeledElementReference().getValue());
        } else if (exp.isNull()) {
            _expression = new EdmNullImpl();
        } else if (exp.isNavigationPropertyPath()) {
            _expression = new EdmNavigationPropertyPathImpl(exp.asNavigationPropertyPath().getValue());
        } else if (exp.isPath()) {
            _expression = new EdmPathImpl(exp.asPath().getValue());
        } else if (exp.isPropertyPath()) {
            _expression = new EdmPropertyPathImpl(exp.asPropertyPath().getValue());
        } else if (exp.isPropertyValue()) {
            _expression = new EdmPropertyValueImpl(exp.asPropertyValue().getProperty(), this.getExpression(exp.asPropertyValue().getValue()));
        } else if (exp.isRecord()) {
            ArrayList<EdmPropertyValue> propertyValues = new ArrayList<EdmPropertyValue>(exp.asRecord().getPropertyValues().size());
            for (PropertyValue propertyValue : exp.asRecord().getPropertyValues()) {
                propertyValues.add((EdmPropertyValue)new EdmPropertyValueImpl(propertyValue.getProperty(), this.getExpression(propertyValue.getValue())));
            }
            _expression = new EdmRecordImpl(this.edm, exp.asRecord().getType(), propertyValues);
        } else if (exp.isUrlRef()) {
            _expression = new EdmUrlRefImpl(this.getExpression(exp.asUrlRef().getValue()));
        }
        if (_expression instanceof EdmAnnotatable && exp instanceof Annotatable) {
            for (Annotation _annotation : ((Annotatable)exp).getAnnotations()) {
                ((EdmAnnotatable)_expression).getAnnotations().add(new EdmAnnotationImpl(this.edm, _annotation));
            }
        }
        return _expression;
    }

    public EdmAnnotationExpression getExpression() {
        if (this.expression == null) {
            this.expression = this.getExpression(this.annotation.getExpression());
        }
        return this.expression;
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        return this.helper.getAnnotation(term);
    }

    public List<EdmAnnotation> getAnnotations() {
        return this.helper.getAnnotations();
    }
}

