/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.olingo.client.api.edm.xml.CommonParameter;
import org.apache.olingo.client.api.edm.xml.ComplexType;
import org.apache.olingo.client.api.edm.xml.EntityContainer;
import org.apache.olingo.client.api.edm.xml.EntityType;
import org.apache.olingo.client.api.edm.xml.EnumType;
import org.apache.olingo.client.api.edm.xml.Schema;
import org.apache.olingo.client.api.edm.xml.v3.FunctionImport;
import org.apache.olingo.client.api.edm.xml.v3.Parameter;
import org.apache.olingo.client.api.edm.xml.v4.Action;
import org.apache.olingo.client.api.edm.xml.v4.Annotatable;
import org.apache.olingo.client.api.edm.xml.v4.Annotation;
import org.apache.olingo.client.api.edm.xml.v4.Annotations;
import org.apache.olingo.client.api.edm.xml.v4.Function;
import org.apache.olingo.client.api.edm.xml.v4.Term;
import org.apache.olingo.client.api.edm.xml.v4.TypeDefinition;
import org.apache.olingo.client.core.edm.AbstractEdmServiceMetadataImpl;
import org.apache.olingo.client.core.edm.EdmActionImpl;
import org.apache.olingo.client.core.edm.EdmAnnotationImpl;
import org.apache.olingo.client.core.edm.EdmAnnotationsImpl;
import org.apache.olingo.client.core.edm.EdmComplexTypeImpl;
import org.apache.olingo.client.core.edm.EdmEntityContainerImpl;
import org.apache.olingo.client.core.edm.EdmEntityTypeImpl;
import org.apache.olingo.client.core.edm.EdmEnumTypeImpl;
import org.apache.olingo.client.core.edm.EdmFunctionImpl;
import org.apache.olingo.client.core.edm.EdmSchemaImpl;
import org.apache.olingo.client.core.edm.EdmTermImpl;
import org.apache.olingo.client.core.edm.EdmTypeDefinitionImpl;
import org.apache.olingo.client.core.edm.v3.EdmActionProxy;
import org.apache.olingo.client.core.edm.v3.EdmFunctionProxy;
import org.apache.olingo.client.core.edm.v3.FunctionImportUtils;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmAnnotations;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmSchema;
import org.apache.olingo.commons.api.edm.EdmServiceMetadata;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.core.edm.AbstractEdm;
import org.apache.olingo.commons.core.edm.AbstractEdmOperation;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;

public class EdmClientImpl
extends AbstractEdm {
    private final ODataServiceVersion version;
    private final List<Schema> xmlSchemas;
    private final Map<String, Schema> xmlSchemaByNamespace;
    private final EdmServiceMetadata serviceMetadata;

    public EdmClientImpl(ODataServiceVersion version, Map<String, Schema> xmlSchemas) {
        this.version = version;
        this.xmlSchemaByNamespace = xmlSchemas;
        this.xmlSchemas = new ArrayList<Schema>();
        for (Schema schema : this.xmlSchemaByNamespace.values()) {
            if (this.xmlSchemas.contains(schema)) continue;
            this.xmlSchemas.add(schema);
        }
        this.serviceMetadata = AbstractEdmServiceMetadataImpl.getInstance(version, this.xmlSchemas);
    }

    protected EdmServiceMetadata createServiceMetadata() {
        return this.serviceMetadata;
    }

    protected Map<String, String> createAliasToNamespaceInfo() {
        HashMap<String, String> aliasToNamespace = new HashMap<String, String>();
        for (Schema schema : this.xmlSchemas) {
            aliasToNamespace.put(null, schema.getNamespace());
            if (!StringUtils.isNotBlank((CharSequence)schema.getAlias())) continue;
            aliasToNamespace.put(schema.getAlias(), schema.getNamespace());
        }
        return aliasToNamespace;
    }

    protected Map<String, EdmSchema> createSchemas() {
        LinkedHashMap<String, EdmSchema> _schemas = new LinkedHashMap<String, EdmSchema>(this.xmlSchemas.size());
        for (Schema schema : this.xmlSchemas) {
            _schemas.put(schema.getNamespace(), (EdmSchema)new EdmSchemaImpl(this.version, (Edm)this, this.xmlSchemas, schema));
        }
        return _schemas;
    }

    protected EdmEntityContainer createEntityContainer(FullQualifiedName containerName) {
        EntityContainer xmlEntityContainer;
        EdmEntityContainerImpl result = null;
        Schema schema = this.xmlSchemaByNamespace.get(containerName.getNamespace());
        if (schema != null && (xmlEntityContainer = schema.getDefaultEntityContainer()) != null) {
            result = new EdmEntityContainerImpl((Edm)this, containerName, xmlEntityContainer, this.xmlSchemas);
        }
        return result;
    }

    protected EdmEnumType createEnumType(FullQualifiedName enumName) {
        EnumType xmlEnumType;
        EdmEnumTypeImpl result = null;
        Schema schema = this.xmlSchemaByNamespace.get(enumName.getNamespace());
        if (schema != null && (xmlEnumType = schema.getEnumType(enumName.getName())) != null) {
            result = new EdmEnumTypeImpl(this.version, (Edm)this, enumName, xmlEnumType);
        }
        return result;
    }

    protected EdmTypeDefinition createTypeDefinition(FullQualifiedName typeDefinitionName) {
        TypeDefinition xmlTypeDefinition;
        EdmTypeDefinitionImpl result = null;
        Schema schema = this.xmlSchemaByNamespace.get(typeDefinitionName.getNamespace());
        if (schema instanceof org.apache.olingo.client.api.edm.xml.v4.Schema && (xmlTypeDefinition = ((org.apache.olingo.client.api.edm.xml.v4.Schema)schema).getTypeDefinition(typeDefinitionName.getName())) != null) {
            result = new EdmTypeDefinitionImpl(this.version, (Edm)this, typeDefinitionName, xmlTypeDefinition);
        }
        return result;
    }

    protected EdmEntityType createEntityType(FullQualifiedName entityTypeName) {
        EntityType xmlEntityType;
        EdmEntityTypeImpl result = null;
        Schema schema = this.xmlSchemaByNamespace.get(entityTypeName.getNamespace());
        if (schema != null && (xmlEntityType = schema.getEntityType(entityTypeName.getName())) != null) {
            result = EdmEntityTypeImpl.getInstance((Edm)this, entityTypeName, this.xmlSchemas, xmlEntityType);
        }
        return result;
    }

    protected EdmComplexType createComplexType(FullQualifiedName complexTypeName) {
        ComplexType xmlComplexType;
        EdmComplexTypeImpl result = null;
        Schema schema = this.xmlSchemaByNamespace.get(complexTypeName.getNamespace());
        if (schema != null && (xmlComplexType = schema.getComplexType(complexTypeName.getName())) != null) {
            result = EdmComplexTypeImpl.getInstance((Edm)this, complexTypeName, this.xmlSchemas, xmlComplexType);
        }
        return result;
    }

    protected EdmAction createUnboundAction(FullQualifiedName actionName) {
        AbstractEdmOperation result = null;
        Schema schema = this.xmlSchemaByNamespace.get(actionName.getNamespace());
        if (schema instanceof org.apache.olingo.client.api.edm.xml.v4.Schema) {
            List actions = ((org.apache.olingo.client.api.edm.xml.v4.Schema)schema).getActions(actionName.getName());
            boolean found = false;
            Iterator itor = actions.iterator();
            while (itor.hasNext() && !found) {
                Action action = (Action)itor.next();
                if (action.isBound()) continue;
                found = true;
                result = EdmActionImpl.getInstance((Edm)this, actionName, action);
            }
        } else {
            for (EntityContainer entityContainer : schema.getEntityContainers()) {
                List functionImports = entityContainer.getFunctionImports(actionName.getName());
                boolean found = false;
                Iterator itor = functionImports.iterator();
                while (itor.hasNext() && !found) {
                    FunctionImport functionImport = (FunctionImport)itor.next();
                    if (FunctionImportUtils.canProxyFunction(functionImport) || functionImport.isBindable()) continue;
                    found = functionImport.getParameters().isEmpty();
                    result = EdmActionProxy.getInstance((Edm)this, actionName, functionImport);
                }
            }
        }
        return result;
    }

    protected List<EdmFunction> createUnboundFunctions(FullQualifiedName functionName) {
        ArrayList<EdmFunction> result = new ArrayList<EdmFunction>();
        Schema schema = this.xmlSchemaByNamespace.get(functionName.getNamespace());
        if (schema instanceof org.apache.olingo.client.api.edm.xml.v4.Schema) {
            List functions = ((org.apache.olingo.client.api.edm.xml.v4.Schema)schema).getFunctions(functionName.getName());
            for (Function function : functions) {
                if (function.isBound()) continue;
                result.add(EdmFunctionImpl.getInstance((Edm)this, functionName, function));
            }
        } else {
            for (EntityContainer entityContainer : schema.getEntityContainers()) {
                List functionImports = entityContainer.getFunctionImports(functionName.getName());
                for (FunctionImport functionImport : functionImports) {
                    if (!FunctionImportUtils.canProxyFunction(functionImport) || functionImport.isBindable()) continue;
                    result.add(EdmFunctionProxy.getInstance((Edm)this, functionName, functionImport));
                }
            }
        }
        return result;
    }

    protected EdmFunction createUnboundFunction(FullQualifiedName functionName, List<String> parameterNames) {
        AbstractEdmOperation result = null;
        Schema schema = this.xmlSchemaByNamespace.get(functionName.getNamespace());
        if (schema instanceof org.apache.olingo.client.api.edm.xml.v4.Schema) {
            List functions = ((org.apache.olingo.client.api.edm.xml.v4.Schema)schema).getFunctions(functionName.getName());
            boolean found = false;
            Iterator itor = functions.iterator();
            while (itor.hasNext() && !found) {
                Function function = (Function)itor.next();
                if (function.isBound()) continue;
                HashSet<String> functionParamNames = new HashSet<String>();
                for (CommonParameter param : function.getParameters()) {
                    functionParamNames.add(param.getName());
                }
                found = parameterNames == null ? functionParamNames.isEmpty() : functionParamNames.containsAll(parameterNames);
                result = EdmFunctionImpl.getInstance((Edm)this, functionName, function);
            }
        } else {
            for (EntityContainer entityContainer : schema.getEntityContainers()) {
                List functionImports = entityContainer.getFunctionImports(functionName.getName());
                boolean found = false;
                Iterator itor = functionImports.iterator();
                while (itor.hasNext() && !found) {
                    FunctionImport functionImport = (FunctionImport)itor.next();
                    if (!FunctionImportUtils.canProxyFunction(functionImport) || functionImport.isBindable()) continue;
                    HashSet<String> functionParamNames = new HashSet<String>();
                    for (CommonParameter param : functionImport.getParameters()) {
                        functionParamNames.add(param.getName());
                    }
                    found = parameterNames == null ? functionParamNames.isEmpty() : functionParamNames.containsAll(parameterNames);
                    result = EdmFunctionProxy.getInstance((Edm)this, functionName, functionImport);
                }
            }
        }
        return result;
    }

    protected EdmAction createBoundAction(FullQualifiedName actionName, FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection) {
        AbstractEdmOperation result = null;
        Schema schema = this.xmlSchemaByNamespace.get(actionName.getNamespace());
        if (schema instanceof org.apache.olingo.client.api.edm.xml.v4.Schema) {
            List actions = ((org.apache.olingo.client.api.edm.xml.v4.Schema)schema).getActions(actionName.getName());
            boolean found = false;
            Iterator itor = actions.iterator();
            while (itor.hasNext() && !found) {
                EdmTypeInfo boundParam;
                Action action = (Action)itor.next();
                if (!action.isBound() || !bindingParameterTypeName.equals((Object)(boundParam = new EdmTypeInfo.Builder().setEdm((Edm)this).setTypeExpression(((org.apache.olingo.client.api.edm.xml.v4.Parameter)action.getParameters().get(0)).getType()).build()).getFullQualifiedName()) || isBindingParameterCollection != null && isBindingParameterCollection.booleanValue() != boundParam.isCollection()) continue;
                found = true;
                result = EdmActionImpl.getInstance((Edm)this, actionName, action);
            }
        } else {
            for (EntityContainer entityContainer : schema.getEntityContainers()) {
                List functionImports = entityContainer.getFunctionImports(actionName.getName());
                boolean found = false;
                Iterator itor = functionImports.iterator();
                while (itor.hasNext() && !found) {
                    EdmTypeInfo boundParam;
                    FunctionImport functionImport = (FunctionImport)itor.next();
                    if (FunctionImportUtils.canProxyFunction(functionImport) || !functionImport.isBindable() || !bindingParameterTypeName.equals((Object)(boundParam = new EdmTypeInfo.Builder().setEdm((Edm)this).setTypeExpression(((Parameter)functionImport.getParameters().get(0)).getType()).build()).getFullQualifiedName()) || isBindingParameterCollection != null && isBindingParameterCollection.booleanValue() != boundParam.isCollection()) continue;
                    found = true;
                    result = EdmActionProxy.getInstance((Edm)this, actionName, functionImport);
                }
            }
        }
        return result;
    }

    protected EdmFunction createBoundFunction(FullQualifiedName functionName, FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection, List<String> parameterNames) {
        AbstractEdmOperation result = null;
        Schema schema = this.xmlSchemaByNamespace.get(functionName.getNamespace());
        if (schema instanceof org.apache.olingo.client.api.edm.xml.v4.Schema) {
            List functions = ((org.apache.olingo.client.api.edm.xml.v4.Schema)schema).getFunctions(functionName.getName());
            boolean found = false;
            Iterator itor = functions.iterator();
            while (itor.hasNext() && !found) {
                EdmTypeInfo boundParam;
                Function function = (Function)itor.next();
                if (!function.isBound() || !bindingParameterTypeName.equals((Object)(boundParam = new EdmTypeInfo.Builder().setEdm((Edm)this).setTypeExpression(((org.apache.olingo.client.api.edm.xml.v4.Parameter)function.getParameters().get(0)).getType()).build()).getFullQualifiedName()) || isBindingParameterCollection != null && isBindingParameterCollection.booleanValue() != boundParam.isCollection()) continue;
                HashSet<String> functionParamNames = new HashSet<String>();
                for (CommonParameter param : function.getParameters()) {
                    functionParamNames.add(param.getName());
                }
                found = parameterNames == null ? functionParamNames.isEmpty() : functionParamNames.containsAll(parameterNames);
                result = EdmFunctionImpl.getInstance((Edm)this, functionName, function);
            }
        } else {
            for (EntityContainer entityContainer : schema.getEntityContainers()) {
                List functionImports = entityContainer.getFunctionImports(functionName.getName());
                boolean found = false;
                Iterator itor = functionImports.iterator();
                while (itor.hasNext() && !found) {
                    EdmTypeInfo boundParam;
                    FunctionImport functionImport = (FunctionImport)itor.next();
                    if (!FunctionImportUtils.canProxyFunction(functionImport) || !functionImport.isBindable() || !bindingParameterTypeName.equals((Object)(boundParam = new EdmTypeInfo.Builder().setEdm((Edm)this).setTypeExpression(((Parameter)functionImport.getParameters().get(0)).getType()).build()).getFullQualifiedName()) || isBindingParameterCollection != null && isBindingParameterCollection.booleanValue() != boundParam.isCollection()) continue;
                    HashSet<String> functionParamNames = new HashSet<String>();
                    for (CommonParameter param : functionImport.getParameters()) {
                        functionParamNames.add(param.getName());
                    }
                    found = parameterNames == null ? functionParamNames.isEmpty() : functionParamNames.containsAll(parameterNames);
                    result = EdmFunctionProxy.getInstance((Edm)this, functionName, functionImport);
                }
            }
        }
        return result;
    }

    protected EdmTerm createTerm(FullQualifiedName termName) {
        Term term;
        EdmTermImpl result = null;
        Schema schema = this.xmlSchemaByNamespace.get(termName.getNamespace());
        if (schema instanceof org.apache.olingo.client.api.edm.xml.v4.Schema && (term = ((org.apache.olingo.client.api.edm.xml.v4.Schema)schema).getTerm(termName.getName())) != null) {
            result = new EdmTermImpl((Edm)this, schema.getNamespace(), term);
        }
        return result;
    }

    protected EdmAnnotations createAnnotationGroup(FullQualifiedName targetName) {
        Annotations annotationGroup;
        EdmAnnotationsImpl result = null;
        Schema schema = this.xmlSchemaByNamespace.get(targetName.getNamespace());
        if (schema instanceof org.apache.olingo.client.api.edm.xml.v4.Schema && (annotationGroup = ((org.apache.olingo.client.api.edm.xml.v4.Schema)schema).getAnnotationGroup(targetName.getName())) != null) {
            result = new EdmAnnotationsImpl((Edm)this, (EdmSchema)this.schemas.get(schema.getNamespace()), annotationGroup);
        }
        return result;
    }

    protected List<EdmAnnotation> createAnnotations(FullQualifiedName annotatedName) {
        Annotatable annotatable;
        ArrayList<EdmAnnotationImpl> result = null;
        Schema schema = this.xmlSchemaByNamespace.get(annotatedName.getNamespace());
        if (schema instanceof org.apache.olingo.client.api.edm.xml.v4.Schema && (annotatable = (Annotatable)((org.apache.olingo.client.api.edm.xml.v4.Schema)schema).getAnnotatables().get(annotatedName.getName())) != null && annotatable.getAnnotations() != null) {
            result = new ArrayList<EdmAnnotationImpl>();
            for (Annotation annotation : annotatable.getAnnotations()) {
                EdmTerm term = this.getTerm(new FullQualifiedName(annotation.getTerm()));
                result.add(new EdmAnnotationImpl((Edm)this, annotation));
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)((Object)this), (String[])new String[0]);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)((Object)this), (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

