/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.api.edm.xml.Member;
import org.apache.olingo.client.api.edm.xml.v4.Annotation;
import org.apache.olingo.client.core.edm.xml.AbstractEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.AbstractEnumType;
import org.apache.olingo.client.core.edm.xml.v3.EnumTypeImpl;
import org.apache.olingo.client.core.edm.xml.v3.MemberImpl;
import org.apache.olingo.client.core.edm.xml.v4.AnnotationImpl;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;

public class EnumTypeDeserializer
extends AbstractEdmDeserializer<AbstractEnumType> {
    @Override
    protected AbstractEnumType doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        AbstractEnumType enumType;
        AbstractEnumType abstractEnumType = enumType = ODataServiceVersion.V30 == this.version ? new EnumTypeImpl() : new org.apache.olingo.client.core.edm.xml.v4.EnumTypeImpl();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                if ("Name".equals(jp.getCurrentName())) {
                    enumType.setName(jp.nextTextValue());
                } else if ("UnderlyingType".equals(jp.getCurrentName())) {
                    enumType.setUnderlyingType(jp.nextTextValue());
                } else if ("IsFlags".equals(jp.getCurrentName())) {
                    enumType.setFlags(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                } else if ("Member".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    if (enumType instanceof EnumTypeImpl) {
                        ((EnumTypeImpl)enumType).getMembers().add((Member)jp.readValueAs(MemberImpl.class));
                    } else {
                        ((org.apache.olingo.client.core.edm.xml.v4.EnumTypeImpl)enumType).getMembers().add((Member)jp.readValueAs(org.apache.olingo.client.core.edm.xml.v4.MemberImpl.class));
                    }
                } else if ("Annotation".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    ((org.apache.olingo.client.core.edm.xml.v4.EnumTypeImpl)enumType).getAnnotations().add((Annotation)jp.readValueAs(AnnotationImpl.class));
                }
            }
            jp.nextToken();
        }
        return enumType;
    }
}

