/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.v4;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.api.edm.xml.v4.Annotation;
import org.apache.olingo.client.core.edm.xml.AbstractEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.v4.AnnotationImpl;
import org.apache.olingo.client.core.edm.xml.v4.TypeDefinitionImpl;
import org.apache.olingo.commons.api.edm.geo.SRID;

public class TypeDefinitionDeserializer
extends AbstractEdmDeserializer<TypeDefinitionImpl> {
    @Override
    protected TypeDefinitionImpl doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        TypeDefinitionImpl typeDefinition = new TypeDefinitionImpl();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                if ("Name".equals(jp.getCurrentName())) {
                    typeDefinition.setName(jp.nextTextValue());
                } else if ("UnderlyingType".equals(jp.getCurrentName())) {
                    typeDefinition.setUnderlyingType(jp.nextTextValue());
                } else if ("MaxLength".equals(jp.getCurrentName())) {
                    typeDefinition.setMaxLength(jp.nextIntValue(0));
                } else if ("Unicode".equals(jp.getCurrentName())) {
                    typeDefinition.setUnicode(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                } else if ("Precision".equals(jp.getCurrentName())) {
                    typeDefinition.setPrecision(jp.nextIntValue(0));
                } else if ("Scale".equals(jp.getCurrentName())) {
                    String scale = jp.nextTextValue();
                    typeDefinition.setScale(scale.equalsIgnoreCase("variable") ? 0 : Integer.valueOf(scale));
                } else if ("SRID".equals(jp.getCurrentName())) {
                    String srid = jp.nextTextValue();
                    if (srid != null) {
                        typeDefinition.setSrid(SRID.valueOf((String)srid));
                    }
                } else if ("Annotation".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    typeDefinition.getAnnotations().add((Annotation)jp.readValueAs(AnnotationImpl.class));
                }
            }
            jp.nextToken();
        }
        return typeDefinition;
    }
}

