/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.v4.annotation;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.apache.olingo.client.api.edm.xml.v4.annotation.DynamicAnnotationExpression;
import org.apache.olingo.client.core.edm.xml.AbstractEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.v4.AnnotationImpl;
import org.apache.olingo.client.core.edm.xml.v4.annotation.AbstractDynamicAnnotationExpression;
import org.apache.olingo.client.core.edm.xml.v4.annotation.LabeledElementImpl;

public class LabeledElementDeserializer
extends AbstractEdmDeserializer<LabeledElementImpl> {
    @Override
    protected LabeledElementImpl doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        LabeledElementImpl element = new LabeledElementImpl();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                if ("Name".equals(jp.getCurrentName())) {
                    element.setName(jp.nextTextValue());
                } else if ("Annotation".equals(jp.getCurrentName())) {
                    element.getAnnotations().add(jp.readValueAs(AnnotationImpl.class));
                } else {
                    element.setValue((DynamicAnnotationExpression)jp.readValueAs(AbstractDynamicAnnotationExpression.class));
                }
            }
            jp.nextToken();
        }
        return element;
    }
}

