/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.uri;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.xml.datatype.Duration;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.http.HttpClientFactory;
import org.apache.olingo.client.api.http.WrappingHttpClientFactory;
import org.apache.olingo.client.api.uri.SegmentType;
import org.apache.olingo.client.core.http.BasicAuthHttpClientFactory;
import org.apache.olingo.client.core.uri.ParameterAlias;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.domain.ODataValue;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.core.edm.primitivetype.EdmBinary;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDateTime;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDateTimeOffset;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDecimal;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDouble;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDuration;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt64;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSingle;
import org.apache.olingo.commons.core.edm.primitivetype.EdmTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class URIUtils {
    private static final Logger LOG = LoggerFactory.getLogger(URIUtils.class);
    private static final Pattern ENUM_VALUE = Pattern.compile("(.+\\.)?.+'.+'");

    private URIUtils() {
    }

    public static URI getURI(String base, String href) {
        if (href == null) {
            throw new IllegalArgumentException("Null link provided");
        }
        URI uri = URI.create(href);
        if (!uri.isAbsolute() && base != null) {
            uri = URI.create(base + "/" + href);
        }
        return uri.normalize();
    }

    public static URI getURI(URI base, URI href) {
        if (href == null) {
            throw new IllegalArgumentException("Null link provided");
        }
        return URIUtils.getURI(base, href.toASCIIString());
    }

    public static URI getURI(URI base, String href) {
        if (href == null) {
            throw new IllegalArgumentException("Null link provided");
        }
        URI uri = URI.create(href);
        if (!uri.isAbsolute() && base != null) {
            uri = URI.create(base.toASCIIString() + "/" + href);
        }
        return uri.normalize();
    }

    private static String prefix(ODataServiceVersion version, EdmPrimitiveTypeKind typeKind) {
        String result = "";
        if (version.compareTo((Enum)ODataServiceVersion.V40) < 0) {
            switch (typeKind) {
                case Guid: {
                    result = "guid'";
                    break;
                }
                case DateTime: {
                    result = "datetime'";
                    break;
                }
                case DateTimeOffset: {
                    result = "datetimeoffset'";
                    break;
                }
                case Binary: {
                    result = "X'";
                    break;
                }
            }
        }
        return result;
    }

    private static String suffix(ODataServiceVersion version, EdmPrimitiveTypeKind typeKind) {
        String result = "";
        if (version.compareTo((Enum)ODataServiceVersion.V40) < 0) {
            switch (typeKind) {
                case Guid: 
                case DateTime: 
                case DateTimeOffset: {
                    result = "'";
                    break;
                }
                case Decimal: {
                    result = "M";
                    break;
                }
                case Double: {
                    result = "D";
                    break;
                }
                case Single: {
                    result = "f";
                    break;
                }
                case Int64: {
                    result = "L";
                    break;
                }
            }
        }
        return result;
    }

    private static String timestamp(ODataServiceVersion version, Timestamp timestamp) throws UnsupportedEncodingException, EdmPrimitiveTypeException {
        return version.compareTo((Enum)ODataServiceVersion.V40) < 0 ? URIUtils.prefix(version, EdmPrimitiveTypeKind.DateTime) + URLEncoder.encode(EdmDateTime.getInstance().valueToString((Object)timestamp, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null), "UTF-8") + URIUtils.suffix(version, EdmPrimitiveTypeKind.DateTime) : URLEncoder.encode(EdmDateTimeOffset.getInstance().valueToString((Object)timestamp, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null), "UTF-8");
    }

    private static String calendar(ODataServiceVersion version, Calendar calendar) throws UnsupportedEncodingException, EdmPrimitiveTypeException {
        return version.compareTo((Enum)ODataServiceVersion.V40) < 0 ? URIUtils.prefix(version, EdmPrimitiveTypeKind.DateTime) + URLEncoder.encode(EdmDateTime.getInstance().valueToString((Object)calendar, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null), "UTF-8") + URIUtils.suffix(version, EdmPrimitiveTypeKind.DateTime) : URLEncoder.encode(EdmDateTimeOffset.getInstance().valueToString((Object)calendar, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null), "UTF-8");
    }

    private static String duration(ODataServiceVersion version, Duration duration) throws UnsupportedEncodingException, EdmPrimitiveTypeException {
        return version.compareTo((Enum)ODataServiceVersion.V40) < 0 ? EdmTime.getInstance().toUriLiteral(URLEncoder.encode(EdmTime.getInstance().valueToString((Object)duration, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null), "UTF-8")) : EdmDuration.getInstance().toUriLiteral(URLEncoder.encode(EdmDuration.getInstance().valueToString((Object)duration, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null), "UTF-8"));
    }

    private static String quoteString(String string, boolean singleQuoteEscape) throws UnsupportedEncodingException {
        return ENUM_VALUE.matcher(string).matches() ? string : (singleQuoteEscape ? "'" + string + "'" : "\"" + string + "\"");
    }

    public static String escape(ODataServiceVersion version, Object obj) {
        return URIUtils.escape(version, obj, true);
    }

    private static String escape(ODataServiceVersion version, Object obj, boolean singleQuoteEscape) {
        String value;
        try {
            if (obj == null) {
                value = "null";
            } else if (version.compareTo((Enum)ODataServiceVersion.V40) >= 0 && obj instanceof Collection) {
                StringBuffer buffer = new StringBuffer("[");
                Iterator itor = ((Collection)obj).iterator();
                while (itor.hasNext()) {
                    buffer.append(URIUtils.escape(version, itor.next(), false));
                    if (!itor.hasNext()) continue;
                    buffer.append(',');
                }
                buffer.append(']');
                value = buffer.toString();
            } else if (version.compareTo((Enum)ODataServiceVersion.V40) >= 0 && obj instanceof Map) {
                StringBuffer buffer = new StringBuffer("{");
                Iterator itor = ((Map)obj).entrySet().iterator();
                while (itor.hasNext()) {
                    Map.Entry entry = itor.next();
                    buffer.append("\"").append((String)entry.getKey()).append("\"");
                    buffer.append(':').append(URIUtils.escape(version, entry.getValue(), false));
                    if (!itor.hasNext()) continue;
                    buffer.append(',');
                }
                buffer.append('}');
                value = buffer.toString();
            } else {
                value = obj instanceof ParameterAlias ? "@" + ((ParameterAlias)obj).getAlias() : (obj instanceof Boolean ? BooleanUtils.toStringTrueFalse((Boolean)((Boolean)obj)) : (obj instanceof UUID ? URIUtils.prefix(version, EdmPrimitiveTypeKind.Guid) + obj.toString() + URIUtils.suffix(version, EdmPrimitiveTypeKind.Guid) : (obj instanceof byte[] ? EdmBinary.getInstance().toUriLiteral(Hex.encodeHexString((byte[])((byte[])obj))) : (obj instanceof Timestamp ? URIUtils.timestamp(version, (Timestamp)obj) : (obj instanceof Calendar ? URIUtils.calendar(version, (Calendar)obj) : (obj instanceof Duration ? URIUtils.duration(version, (Duration)obj) : (obj instanceof BigDecimal ? EdmDecimal.getInstance().valueToString(obj, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null) + URIUtils.suffix(version, EdmPrimitiveTypeKind.Decimal) : (obj instanceof Double ? EdmDouble.getInstance().valueToString(obj, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null) + URIUtils.suffix(version, EdmPrimitiveTypeKind.Double) : (obj instanceof Float ? EdmSingle.getInstance().valueToString(obj, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null) + URIUtils.suffix(version, EdmPrimitiveTypeKind.Single) : (obj instanceof Long ? EdmInt64.getInstance().valueToString(obj, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null) + URIUtils.suffix(version, EdmPrimitiveTypeKind.Int64) : (obj instanceof Geospatial ? URLEncoder.encode(EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)((Geospatial)obj).getEdmPrimitiveTypeKind()).valueToString(obj, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null), "UTF-8") : (obj instanceof String ? URIUtils.quoteString((String)obj, singleQuoteEscape) : obj.toString()))))))))))));
            }
        }
        catch (Exception e) {
            LOG.warn("While escaping '{}', using toString()", obj, (Object)e);
            value = obj.toString();
        }
        return value;
    }

    public static boolean shouldUseRepeatableHttpBodyEntry(CommonODataClient<?> client) {
        WrappingHttpClientFactory tmp;
        HttpClientFactory httpclientFactory = client.getConfiguration().getHttpClientFactory();
        if (httpclientFactory instanceof BasicAuthHttpClientFactory) {
            return true;
        }
        return httpclientFactory instanceof WrappingHttpClientFactory && (tmp = (WrappingHttpClientFactory)httpclientFactory).getWrappedHttpClientFactory() instanceof BasicAuthHttpClientFactory;
    }

    public static HttpEntity buildInputStreamEntity(CommonODataClient<?> client, InputStream input) {
        InputStreamEntity entity;
        boolean useChunked = client.getConfiguration().isUseChuncked();
        if (URIUtils.shouldUseRepeatableHttpBodyEntry(client) || !useChunked) {
            byte[] bytes = new byte[]{};
            try {
                bytes = IOUtils.toByteArray((InputStream)input);
                IOUtils.closeQuietly((InputStream)input);
            }
            catch (IOException e) {
                LOG.error("While reading input for not chunked encoding", (Throwable)e);
            }
            entity = new ByteArrayEntity(bytes);
        } else {
            entity = new InputStreamEntity(input, -1L);
        }
        if (!useChunked && entity.getContentLength() < 0L) {
            LOG.error("Could not determine length - request will be sent as chunked.");
            useChunked = true;
        }
        entity.setChunked(useChunked);
        return entity;
    }

    public static URI addValueSegment(URI uri) {
        URI res;
        if (uri.getPath().endsWith(SegmentType.VALUE.getValue())) {
            res = uri;
        } else {
            try {
                res = new URIBuilder(uri).setPath(uri.getPath() + "/" + SegmentType.VALUE.getValue()).build();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return res;
    }

    public static URI buildFunctionInvokeURI(URI uri, Map<String, ODataValue> parameters, ODataServiceVersion serviceVersion) {
        if (serviceVersion.compareTo((Enum)ODataServiceVersion.V40) >= 0) {
            String rawQuery = uri.getRawQuery();
            String baseURI = StringUtils.substringBefore((String)uri.toASCIIString(), (String)("?" + rawQuery));
            if (baseURI.endsWith("()")) {
                baseURI = baseURI.substring(0, baseURI.length() - 2);
            }
            StringBuilder inlineParams = new StringBuilder();
            for (Map.Entry<String, ODataValue> param : parameters.entrySet()) {
                inlineParams.append(param.getKey()).append("=");
                Object value = null;
                if (param.getValue().isPrimitive()) {
                    value = param.getValue().asPrimitive().toValue();
                } else if (param.getValue().isComplex()) {
                    value = param.getValue().asComplex().asJavaMap();
                } else if (param.getValue().isCollection()) {
                    value = param.getValue().asCollection().asJavaCollection();
                } else if (param.getValue() instanceof org.apache.olingo.commons.api.domain.v4.ODataValue && ((org.apache.olingo.commons.api.domain.v4.ODataValue)param.getValue()).isEnum()) {
                    value = ((org.apache.olingo.commons.api.domain.v4.ODataValue)param.getValue()).asEnum().toString();
                }
                inlineParams.append(URIUtils.escape(serviceVersion, value)).append(',');
            }
            if (inlineParams.length() > 0) {
                inlineParams.deleteCharAt(inlineParams.length() - 1);
            }
            try {
                return URI.create(baseURI + "(" + URLEncoder.encode(inlineParams.toString(), "UTF-8") + ")" + (StringUtils.isNotBlank((CharSequence)rawQuery) ? "?" + rawQuery : ""));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("While adding GET parameters", e);
            }
        }
        URIBuilder uriBuilder = new URIBuilder(uri);
        for (Map.Entry<String, ODataValue> param : parameters.entrySet()) {
            if (!param.getValue().isPrimitive()) {
                throw new IllegalArgumentException("Only primitive values can be passed via GET");
            }
            uriBuilder.addParameter(param.getKey(), URIUtils.escape(serviceVersion, param.getValue()));
        }
        try {
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("While adding GET parameters", e);
        }
    }
}

