/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.olingo.client.api.Configuration;
import org.apache.olingo.client.api.http.HttpClientFactory;
import org.apache.olingo.client.api.http.HttpUriRequestFactory;
import org.apache.olingo.client.core.http.DefaultHttpClientFactory;
import org.apache.olingo.client.core.http.DefaultHttpUriRequestFactory;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.format.ODataFormat;

public class ConfigurationImpl
implements Configuration {
    private static final String DEFAULT_PUB_FORMAT = "pubFormat";
    private static final String DEFAULT_VALUE_FORMAT = "valueFormat";
    private static final String DEFAULT_BATCH_ACCEPT_FORMAT = "batchAcceptFormat";
    private static final String DEFAULT_MEDIA_FORMAT = "valueFormat";
    private static final String HTTP_CLIENT_FACTORY = "httpClientFactory";
    private static final String HTTP_URI_REQUEST_FACTORY = "httpUriRequestFactory";
    private static final String USE_XHTTP_METHOD = "useHTTPMethod";
    private static final String KEY_AS_SEGMENT = "keyAsSegment";
    private static final String ADDRESS_DERIVED_TYPE = "addressDerivedType";
    private static final String USE_OPERATION_FQN_IN_URL = "useOperationFqnInUrl";
    private static final String GZIP_COMPRESSION = "gzipCompression";
    private static final String CHUNKING = "chunking";
    private static final String CONTINUE_ON_ERROR = "continueOnError";
    private final Map<String, Object> CONF = new HashMap<String, Object>();
    private transient ExecutorService executor = Executors.newFixedThreadPool(10);

    protected Object getProperty(String key, Object defaultValue) {
        return this.CONF.containsKey(key) ? this.CONF.get(key) : defaultValue;
    }

    protected Object setProperty(String key, Object value) {
        return this.CONF.put(key, value);
    }

    public ContentType getDefaultBatchAcceptFormat() {
        return (ContentType)this.getProperty(DEFAULT_BATCH_ACCEPT_FORMAT, ContentType.MULTIPART_MIXED);
    }

    public void setDefaultBatchAcceptFormat(ContentType contentType) {
        this.setProperty(DEFAULT_BATCH_ACCEPT_FORMAT, contentType);
    }

    public ODataFormat getDefaultPubFormat() {
        return (ODataFormat)this.getProperty(DEFAULT_PUB_FORMAT, ODataFormat.JSON_FULL_METADATA);
    }

    public void setDefaultPubFormat(ODataFormat format) {
        this.setProperty(DEFAULT_PUB_FORMAT, format);
    }

    public ODataFormat getDefaultFormat() {
        ODataFormat format = this.getDefaultPubFormat();
        return format == ODataFormat.ATOM ? ODataFormat.XML : format;
    }

    public ODataFormat getDefaultValueFormat() {
        return (ODataFormat)this.getProperty("valueFormat", ODataFormat.TEXT_PLAIN);
    }

    public void setDefaultValueFormat(ODataFormat format) {
        this.setProperty("valueFormat", format);
    }

    public ODataFormat getDefaultMediaFormat() {
        return (ODataFormat)this.getProperty("valueFormat", ODataFormat.APPLICATION_OCTET_STREAM);
    }

    public void setDefaultMediaFormat(ODataFormat format) {
        this.setProperty("valueFormat", format);
    }

    public HttpClientFactory getHttpClientFactory() {
        return (HttpClientFactory)this.getProperty(HTTP_CLIENT_FACTORY, new DefaultHttpClientFactory());
    }

    public void setHttpClientFactory(HttpClientFactory factory) {
        this.setProperty(HTTP_CLIENT_FACTORY, factory);
    }

    public HttpUriRequestFactory getHttpUriRequestFactory() {
        return (HttpUriRequestFactory)this.getProperty(HTTP_URI_REQUEST_FACTORY, new DefaultHttpUriRequestFactory());
    }

    public void setHttpUriRequestFactory(HttpUriRequestFactory factory) {
        this.setProperty(HTTP_URI_REQUEST_FACTORY, factory);
    }

    public boolean isUseXHTTPMethod() {
        return (Boolean)this.getProperty(USE_XHTTP_METHOD, false);
    }

    public void setUseXHTTPMethod(boolean value) {
        this.setProperty(USE_XHTTP_METHOD, value);
    }

    public boolean isGzipCompression() {
        return (Boolean)this.getProperty(GZIP_COMPRESSION, false);
    }

    public void setGzipCompression(boolean value) {
        this.setProperty(GZIP_COMPRESSION, value);
    }

    public boolean isUseChuncked() {
        return (Boolean)this.getProperty(CHUNKING, true);
    }

    public void setUseChuncked(boolean value) {
        this.setProperty(CHUNKING, value);
    }

    public boolean isKeyAsSegment() {
        return (Boolean)this.getProperty(KEY_AS_SEGMENT, false);
    }

    public void setKeyAsSegment(boolean value) {
        this.setProperty(KEY_AS_SEGMENT, value);
    }

    public boolean isAddressingDerivedTypes() {
        return (Boolean)this.getProperty(ADDRESS_DERIVED_TYPE, true);
    }

    public void setAddressingDerivedTypes(boolean value) {
        this.setProperty(ADDRESS_DERIVED_TYPE, value);
    }

    public boolean isUseUrlOperationFQN() {
        return (Boolean)this.getProperty(USE_OPERATION_FQN_IN_URL, true);
    }

    public void setUseUrlOperationFQN(boolean value) {
        this.setProperty(USE_OPERATION_FQN_IN_URL, value);
    }

    public boolean isContinueOnError() {
        return (Boolean)this.getProperty(CONTINUE_ON_ERROR, false);
    }

    public void setContinueOnError(boolean value) {
        this.setProperty(CONTINUE_ON_ERROR, value);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executorService) {
        this.executor = executorService;
    }
}

