/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.header;

import java.io.InputStream;
import org.apache.http.StatusLine;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.communication.ODataClientErrorException;
import org.apache.olingo.client.api.communication.ODataServerErrorException;
import org.apache.olingo.commons.api.ODataRuntimeException;
import org.apache.olingo.commons.api.domain.ODataError;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ODataErrorResponseChecker {
    protected static final Logger LOG = LoggerFactory.getLogger(ODataErrorResponseChecker.class);

    private static ODataError getGenericError(int code, String errorMsg) {
        ODataError error = new ODataError();
        error.setCode(String.valueOf(code));
        error.setMessage(errorMsg);
        return error;
    }

    public static ODataRuntimeException checkResponse(CommonODataClient<?> odataClient, StatusLine statusLine, InputStream entity, String accept) {
        Object result = null;
        if (entity == null) {
            result = new ODataClientErrorException(statusLine);
        } else {
            ODataError error;
            ODataFormat format = accept.contains("xml") ? ODataFormat.XML : ODataFormat.JSON;
            try {
                error = odataClient.getReader().readError(entity, format);
            }
            catch (RuntimeException e) {
                LOG.warn("Error deserializing error response", (Throwable)e);
                error = ODataErrorResponseChecker.getGenericError(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            catch (ODataDeserializerException e) {
                LOG.warn("Error deserializing error response", (Throwable)e);
                error = ODataErrorResponseChecker.getGenericError(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            result = statusLine.getStatusCode() >= 500 ? new ODataServerErrorException(statusLine) : new ODataClientErrorException(statusLine, error);
        }
        return result;
    }

    private ODataErrorResponseChecker() {
    }
}

