/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.batch;

import java.io.PipedOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.communication.request.ODataPayloadManager;
import org.apache.olingo.client.api.communication.request.batch.CommonODataBatchRequest;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchResponseItem;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.client.core.communication.request.streamed.AbstractODataStreamedRequest;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;

public abstract class AbstractODataBatchRequest<V extends ODataResponse, T extends ODataPayloadManager<V>>
extends AbstractODataStreamedRequest<V, T> {
    protected final String boundary;
    protected final List<ODataBatchResponseItem> expectedResItems = new ArrayList<ODataBatchResponseItem>();

    protected AbstractODataBatchRequest(CommonODataClient<?> odataClient, URI uri) {
        super(odataClient, HttpMethod.POST, uri);
        this.boundary = "batch_" + UUID.randomUUID().toString();
        this.setContentType(ContentType.MULTIPART_MIXED + ";" + "boundary" + "=" + this.boundary);
    }

    protected void addExpectedResItem(ODataBatchResponseItem item) {
        this.expectedResItems.add(item);
    }

    public PipedOutputStream getOutputStream() {
        return this.getPayloadManager().getBodyStreamWriter();
    }

    @Override
    public void batch(CommonODataBatchRequest req) {
        throw new UnsupportedOperationException("A batch request is not batchable");
    }
}

