/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.cud;

import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.communication.request.cud.ODataPropertyUpdateRequest;
import org.apache.olingo.client.api.communication.response.ODataPropertyUpdateResponse;
import org.apache.olingo.client.core.communication.request.AbstractODataBasicRequest;
import org.apache.olingo.client.core.communication.response.AbstractODataResponse;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.domain.CommonODataProperty;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;
import org.apache.olingo.commons.api.serialization.ODataSerializerException;

public class ODataPropertyUpdateRequestImpl
extends AbstractODataBasicRequest<ODataPropertyUpdateResponse>
implements ODataPropertyUpdateRequest {
    private final CommonODataProperty property;

    ODataPropertyUpdateRequestImpl(CommonODataClient<?> odataClient, HttpMethod method, URI targetURI, CommonODataProperty property) {
        super(odataClient, method, targetURI);
        this.property = property;
    }

    @Override
    public ODataFormat getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataPropertyUpdateResponse execute() {
        InputStream input = this.getPayload();
        ((HttpEntityEnclosingRequestBase)this.request).setEntity(URIUtils.buildInputStreamEntity(this.odataClient, input));
        try {
            ODataPropertyUpdateResponseImpl oDataPropertyUpdateResponseImpl = new ODataPropertyUpdateResponseImpl(this.odataClient, this.httpClient, this.doExecute());
            return oDataPropertyUpdateResponseImpl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    @Override
    protected InputStream getPayload() {
        try {
            return this.odataClient.getWriter().writeProperty(this.property, ODataFormat.fromString((String)this.getContentType()));
        }
        catch (ODataSerializerException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private class ODataPropertyUpdateResponseImpl
    extends AbstractODataResponse
    implements ODataPropertyUpdateResponse {
        private CommonODataProperty property;

        private ODataPropertyUpdateResponseImpl(CommonODataClient<?> odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.property = null;
        }

        public CommonODataProperty getBody() {
            if (this.property == null) {
                try {
                    ResWrap resource = this.odataClient.getDeserializer(ODataFormat.fromString((String)ODataPropertyUpdateRequestImpl.this.getAccept())).toProperty(this.getRawResponse());
                    this.property = this.odataClient.getBinder().getODataProperty(resource);
                }
                catch (ODataDeserializerException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            return this.property;
        }
    }
}

