/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.cud;

import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.communication.request.cud.ODataValueUpdateRequest;
import org.apache.olingo.client.api.communication.response.ODataValueUpdateResponse;
import org.apache.olingo.client.api.http.HttpClientException;
import org.apache.olingo.client.core.communication.request.AbstractODataBasicRequest;
import org.apache.olingo.client.core.communication.response.AbstractODataResponse;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.domain.ODataPrimitiveValue;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.http.HttpMethod;

public class ODataValueUpdateRequestImpl
extends AbstractODataBasicRequest<ODataValueUpdateResponse>
implements ODataValueUpdateRequest {
    private final ODataPrimitiveValue value;

    ODataValueUpdateRequestImpl(CommonODataClient<?> odataClient, HttpMethod method, URI targetURI, ODataPrimitiveValue value) {
        super(odataClient, method, targetURI);
        this.value = value;
    }

    @Override
    public ODataFormat getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultValueFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataValueUpdateResponse execute() {
        InputStream input = this.getPayload();
        ((HttpEntityEnclosingRequestBase)this.request).setEntity(URIUtils.buildInputStreamEntity(this.odataClient, input));
        try {
            ODataValueUpdateResponseImpl oDataValueUpdateResponseImpl = new ODataValueUpdateResponseImpl(this.odataClient, this.httpClient, this.doExecute());
            return oDataValueUpdateResponseImpl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    @Override
    protected InputStream getPayload() {
        return IOUtils.toInputStream((String)this.value.toString());
    }

    private class ODataValueUpdateResponseImpl
    extends AbstractODataResponse
    implements ODataValueUpdateResponse {
        private ODataPrimitiveValue value;

        private ODataValueUpdateResponseImpl(CommonODataClient<?> odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.value = null;
        }

        public ODataPrimitiveValue getBody() {
            if (this.value == null) {
                ODataFormat format = ODataFormat.fromString((String)ODataValueUpdateRequestImpl.this.getAccept());
                try {
                    this.value = this.odataClient.getObjectFactory().newPrimitiveValueBuilder().setType(format == ODataFormat.TEXT_PLAIN ? EdmPrimitiveTypeKind.String : EdmPrimitiveTypeKind.Stream).setValue((Object)this.getRawResponse()).build();
                }
                catch (Exception e) {
                    throw new HttpClientException((Throwable)e);
                }
                finally {
                    this.close();
                }
            }
            return this.value;
        }
    }
}

