/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.cud.v3;

import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.communication.request.cud.v3.ODataLinkUpdateRequest;
import org.apache.olingo.client.api.communication.response.ODataLinkOperationResponse;
import org.apache.olingo.client.core.communication.request.AbstractODataBasicRequest;
import org.apache.olingo.client.core.communication.response.AbstractODataResponse;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.domain.ODataLink;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.api.serialization.ODataSerializerException;

public class ODataLinkUpdateRequestImpl
extends AbstractODataBasicRequest<ODataLinkOperationResponse>
implements ODataLinkUpdateRequest {
    private final ODataLink link;

    public ODataLinkUpdateRequestImpl(CommonODataClient<?> odataClient, HttpMethod method, URI targetURI, ODataLink link) {
        super(odataClient, method, targetURI);
        this.link = link;
    }

    @Override
    public ODataFormat getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataLinkOperationResponse execute() {
        InputStream input = this.getPayload();
        ((HttpEntityEnclosingRequestBase)this.request).setEntity(URIUtils.buildInputStreamEntity(this.odataClient, input));
        try {
            ODataLinkUpdateResponseImpl oDataLinkUpdateResponseImpl = new ODataLinkUpdateResponseImpl(this.odataClient, this.httpClient, this.doExecute());
            return oDataLinkUpdateResponseImpl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    @Override
    protected InputStream getPayload() {
        try {
            return this.odataClient.getWriter().writeLink(this.link, ODataFormat.fromString((String)this.getContentType()));
        }
        catch (ODataSerializerException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public class ODataLinkUpdateResponseImpl
    extends AbstractODataResponse
    implements ODataLinkOperationResponse {
        public ODataLinkUpdateResponseImpl(CommonODataClient<?> odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
        }
    }
}

