/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.ODataRawRequest;
import org.apache.olingo.client.api.communication.response.ODataRawResponse;
import org.apache.olingo.client.core.communication.request.AbstractODataRequest;
import org.apache.olingo.client.core.communication.response.AbstractODataResponse;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;

public class ODataRawRequestImpl
extends AbstractODataRequest
implements ODataRawRequest {
    ODataRawRequestImpl(CommonODataClient<?> odataClient, URI uri) {
        super(odataClient, HttpMethod.GET, uri);
    }

    @Override
    public ODataFormat getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultPubFormat();
    }

    public void setFormat(String format) {
        this.setAccept(format);
        this.setContentType(format);
    }

    public ODataRawResponse execute() {
        return new ODataRawResponseImpl(this.odataClient, this.httpClient, this.doExecute());
    }

    private class ODataRawResponseImpl
    extends AbstractODataResponse
    implements ODataRawResponse {
        private byte[] obj;

        private ODataRawResponseImpl(CommonODataClient<?> odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.obj = null;
        }

        public <T> ResWrap<T> getBodyAs(Class<T> reference) {
            if (this.obj == null) {
                try {
                    this.obj = IOUtils.toByteArray((InputStream)this.getRawResponse());
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            try {
                return this.odataClient.getReader().read((InputStream)new ByteArrayInputStream(this.obj), this.getContentType(), reference);
            }
            catch (ODataDeserializerException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

