/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve;

import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.ODataServiceDocumentRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.data.ServiceDocument;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractODataRetrieveRequest;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.domain.ODataServiceDocument;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;

public class ODataServiceDocumentRequestImpl
extends AbstractODataRetrieveRequest<ODataServiceDocument>
implements ODataServiceDocumentRequest {
    ODataServiceDocumentRequestImpl(CommonODataClient<?> odataClient, URI uri) {
        super(odataClient, uri);
    }

    @Override
    public ODataFormat getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultFormat();
    }

    @Override
    public ODataRetrieveResponse<ODataServiceDocument> execute() {
        HttpResponse res = this.doExecute();
        return new ODataServiceResponseImpl(this.odataClient, this.httpClient, res);
    }

    protected class ODataServiceResponseImpl
    extends AbstractODataRetrieveRequest.AbstractODataRetrieveResponse {
        private ODataServiceDocument serviceDocument;

        private ODataServiceResponseImpl(CommonODataClient<?> odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.serviceDocument = null;
        }

        public ODataServiceDocument getBody() {
            if (this.serviceDocument == null) {
                try {
                    ResWrap resource = this.odataClient.getDeserializer(ODataFormat.fromString((String)this.getContentType())).toServiceDocument(this.getRawResponse());
                    this.serviceDocument = this.odataClient.getBinder().getODataServiceDocument((ServiceDocument)resource.getPayload());
                }
                catch (ODataDeserializerException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            return this.serviceDocument;
        }
    }
}

