/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve.v4;

import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.v4.ODataDeltaRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.http.HttpClientException;
import org.apache.olingo.client.api.v4.ODataClient;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractODataRetrieveRequest;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.domain.v4.ODataDelta;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;

public class ODataDeltaRequestImpl
extends AbstractODataRetrieveRequest<ODataDelta>
implements ODataDeltaRequest {
    public ODataDeltaRequestImpl(CommonODataClient<?> odataClient, URI query) {
        super(odataClient, query);
    }

    @Override
    public ODataFormat getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultPubFormat();
    }

    @Override
    public ODataRetrieveResponse<ODataDelta> execute() {
        HttpResponse res = this.doExecute();
        return new ODataDeltaResponseImpl(this.odataClient, this.httpClient, res);
    }

    protected class ODataDeltaResponseImpl
    extends AbstractODataRetrieveRequest.AbstractODataRetrieveResponse {
        private ODataDelta delta;

        private ODataDeltaResponseImpl(CommonODataClient<?> odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.delta = null;
        }

        public ODataDelta getBody() {
            if (this.delta == null) {
                try {
                    ResWrap resource = ((ODataClient)this.odataClient).getDeserializer(ODataFormat.fromString((String)this.getContentType())).toDelta(this.res.getEntity().getContent());
                    this.delta = ((ODataClient)this.odataClient).getBinder().getODataDelta(resource);
                }
                catch (IOException e) {
                    throw new HttpClientException((Throwable)e);
                }
                catch (ODataDeserializerException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            return this.delta;
        }
    }
}

