/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve.v4;

import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.XMLMetadataRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.edm.xml.Schema;
import org.apache.olingo.client.api.edm.xml.XMLMetadata;
import org.apache.olingo.client.api.edm.xml.v4.Annotation;
import org.apache.olingo.client.api.edm.xml.v4.Annotations;
import org.apache.olingo.client.api.edm.xml.v4.Include;
import org.apache.olingo.client.api.edm.xml.v4.Reference;
import org.apache.olingo.client.api.v4.ODataClient;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractMetadataRequestImpl;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractODataRetrieveRequest;
import org.apache.olingo.client.core.edm.xml.AbstractSchema;
import org.apache.olingo.client.core.edm.xml.v4.AnnotationsImpl;
import org.apache.olingo.client.core.edm.xml.v4.SchemaImpl;
import org.apache.olingo.commons.api.format.ODataFormat;

public class XMLMetadataRequestImpl
extends AbstractMetadataRequestImpl<XMLMetadata>
implements XMLMetadataRequest {
    XMLMetadataRequestImpl(ODataClient odataClient, URI uri) {
        super((CommonODataClient<?>)odataClient, uri);
    }

    @Override
    public ODataRetrieveResponse<XMLMetadata> execute() {
        SingleXMLMetadatRequestImpl rootReq = new SingleXMLMetadatRequestImpl((ODataClient)this.odataClient, this.uri, null);
        ODataRetrieveResponse<org.apache.olingo.client.api.edm.xml.v4.XMLMetadata> rootRes = rootReq.execute();
        XMLMetadataResponseImpl response = new XMLMetadataResponseImpl(this.odataClient, this.httpClient, rootReq.getHttpResponse(), (org.apache.olingo.client.api.edm.xml.v4.XMLMetadata)rootRes.getBody());
        for (Reference reference : ((org.apache.olingo.client.api.edm.xml.v4.XMLMetadata)rootRes.getBody()).getReferences()) {
            SingleXMLMetadatRequestImpl includeReq = new SingleXMLMetadatRequestImpl((ODataClient)this.odataClient, this.odataClient.newURIBuilder(this.uri.resolve(reference.getUri()).toASCIIString()).build(), this.uri);
            org.apache.olingo.client.api.edm.xml.v4.XMLMetadata includeMetadata = (org.apache.olingo.client.api.edm.xml.v4.XMLMetadata)includeReq.execute().getBody();
            for (Include include : reference.getIncludes()) {
                org.apache.olingo.client.api.edm.xml.v4.Schema includedSchema = includeMetadata.getSchema(include.getNamespace());
                if (includedSchema == null) continue;
                response.getBody().getSchemas().add(includedSchema);
                if (!StringUtils.isNotBlank((CharSequence)include.getAlias())) continue;
                ((AbstractSchema)includedSchema).setAlias(include.getAlias());
            }
            for (Include include : reference.getIncludeAnnotations()) {
                for (Schema schema : includeMetadata.getSchemas()) {
                    SchemaImpl forInclusion = new SchemaImpl();
                    forInclusion.setNamespace(schema.getNamespace());
                    forInclusion.setAlias(schema.getAlias());
                    for (Annotations annotationGroup : ((SchemaImpl)schema).getAnnotationGroups()) {
                        if (!StringUtils.isBlank((CharSequence)include.getTargetNamespace()) && !include.getTargetNamespace().equals(StringUtils.substringBeforeLast((String)annotationGroup.getTarget(), (String)".")) || !StringUtils.isBlank((CharSequence)include.getQualifier()) && !include.getQualifier().equals(annotationGroup.getQualifier())) continue;
                        AnnotationsImpl toBeIncluded = new AnnotationsImpl();
                        toBeIncluded.setTarget(annotationGroup.getTarget());
                        toBeIncluded.setQualifier(annotationGroup.getQualifier());
                        for (Annotation annotation : annotationGroup.getAnnotations()) {
                            if (!include.getTermNamespace().equals(StringUtils.substringBeforeLast((String)annotation.getTerm(), (String)"."))) continue;
                            toBeIncluded.getAnnotations().add(annotation);
                        }
                        forInclusion.getAnnotationGroups().add(toBeIncluded);
                    }
                    if (forInclusion.getAnnotationGroups().isEmpty()) continue;
                    response.getBody().getSchemas().add(forInclusion);
                }
            }
        }
        return response;
    }

    private class XMLMetadataResponseImpl
    extends AbstractODataRetrieveRequest.AbstractODataRetrieveResponse {
        private final org.apache.olingo.client.api.edm.xml.v4.XMLMetadata metadata;

        private XMLMetadataResponseImpl(CommonODataClient<?> odataClient, HttpClient httpClient, HttpResponse res, org.apache.olingo.client.api.edm.xml.v4.XMLMetadata metadata) {
            super(odataClient, httpClient, null);
            this.metadata = metadata;
            this.statusCode = res.getStatusLine().getStatusCode();
            this.statusMessage = res.getStatusLine().getReasonPhrase();
            this.hasBeenInitialized = true;
        }

        public org.apache.olingo.client.api.edm.xml.v4.XMLMetadata getBody() {
            return this.metadata;
        }
    }

    private class SingleXMLMetadatRequestImpl
    extends AbstractMetadataRequestImpl<org.apache.olingo.client.api.edm.xml.v4.XMLMetadata> {
        private final URI parentURI;
        private HttpResponse httpResponse;

        public SingleXMLMetadatRequestImpl(ODataClient odataClient, URI uri, URI parent) {
            super((CommonODataClient<?>)odataClient, uri);
            this.parentURI = parent;
        }

        public HttpResponse getHttpResponse() {
            return this.httpResponse;
        }

        @Override
        protected void checkRequest(CommonODataClient<?> odataClient, HttpUriRequest request) {
            if (this.parentURI == null) {
                super.checkRequest(odataClient, request);
            } else if (!this.parentURI.getScheme().equals(this.uri.getScheme()) || !this.parentURI.getAuthority().equals(this.uri.getAuthority())) {
                throw new IllegalArgumentException(String.format("The referenced EDMX document has the URI '%s' where scheme, host, or port is different from the main metadata document URI '%s'.", this.uri.toASCIIString(), this.parentURI.toASCIIString()));
            }
        }

        @Override
        public ODataRetrieveResponse<org.apache.olingo.client.api.edm.xml.v4.XMLMetadata> execute() {
            this.httpResponse = this.doExecute();
            return new AbstractODataRetrieveRequest.AbstractODataRetrieveResponse(this.odataClient, this.httpClient, this.httpResponse){
                private org.apache.olingo.client.api.edm.xml.v4.XMLMetadata metadata;
                {
                    this.metadata = null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public org.apache.olingo.client.api.edm.xml.v4.XMLMetadata getBody() {
                    if (this.metadata == null) {
                        try {
                            this.metadata = ((ODataClient)this.odataClient).getDeserializer(ODataFormat.XML).toMetadata(this.getRawResponse());
                        }
                        finally {
                            this.close();
                        }
                    }
                    return this.metadata;
                }
            };
        }
    }
}

