/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.client.api.edm.xml.CommonNavigationProperty;
import org.apache.olingo.client.api.edm.xml.CommonProperty;
import org.apache.olingo.client.api.edm.xml.EntityType;
import org.apache.olingo.client.api.edm.xml.Schema;
import org.apache.olingo.client.api.edm.xml.v3.NavigationProperty;
import org.apache.olingo.client.api.edm.xml.v4.ComplexType;
import org.apache.olingo.client.core.edm.EdmNavigationPropertyImpl;
import org.apache.olingo.client.core.edm.EdmPropertyImpl;
import org.apache.olingo.client.core.edm.v3.EdmNavigationPropertyProxy;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.EdmStructuredTypeHelper;

public class EdmStructuredTypeHelperImpl
implements EdmStructuredTypeHelper {
    private final Edm edm;
    private final FullQualifiedName structuredTypeName;
    private final org.apache.olingo.client.api.edm.xml.ComplexType complexType;
    private final List<? extends Schema> xmlSchemas;
    private Map<String, EdmProperty> properties;
    private Map<String, EdmNavigationProperty> navigationProperties;

    public EdmStructuredTypeHelperImpl(Edm edm, FullQualifiedName structuredTypeName, List<? extends Schema> xmlSchemas, org.apache.olingo.client.api.edm.xml.ComplexType complexType) {
        this.edm = edm;
        this.structuredTypeName = structuredTypeName;
        this.complexType = complexType;
        this.xmlSchemas = xmlSchemas;
    }

    public Map<String, EdmProperty> getProperties() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, EdmProperty>();
            for (CommonProperty property : this.complexType.getProperties()) {
                this.properties.put(property.getName(), (EdmProperty)new EdmPropertyImpl(this.edm, this.structuredTypeName, property));
            }
        }
        return this.properties;
    }

    public Map<String, EdmNavigationProperty> getNavigationProperties() {
        if (this.navigationProperties == null) {
            this.navigationProperties = new LinkedHashMap<String, EdmNavigationProperty>();
            for (CommonNavigationProperty navigationProperty : this.complexType.getNavigationProperties()) {
                if (navigationProperty instanceof org.apache.olingo.client.api.edm.xml.v4.NavigationProperty) {
                    this.navigationProperties.put(navigationProperty.getName(), (EdmNavigationProperty)new EdmNavigationPropertyImpl(this.edm, this.structuredTypeName, (org.apache.olingo.client.api.edm.xml.v4.NavigationProperty)navigationProperty));
                    continue;
                }
                if (!(navigationProperty instanceof NavigationProperty)) continue;
                this.navigationProperties.put(navigationProperty.getName(), (EdmNavigationProperty)new EdmNavigationPropertyProxy(this.edm, this.xmlSchemas, (NavigationProperty)navigationProperty));
            }
        }
        return this.navigationProperties;
    }

    public boolean isOpenType() {
        return this.complexType instanceof ComplexType ? ((ComplexType)this.complexType).isOpenType() : (this.complexType instanceof EntityType ? ((EntityType)this.complexType).isOpenType() : false);
    }

    public boolean isAbstract() {
        return this.complexType instanceof ComplexType ? ((ComplexType)this.complexType).isAbstractEntityType() : (this.complexType instanceof EntityType ? ((EntityType)this.complexType).isAbstractEntityType() : false);
    }
}

