/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.edm.xml.Edmx;
import org.apache.olingo.client.api.edm.xml.Schema;
import org.apache.olingo.client.api.edm.xml.XMLMetadata;
import org.apache.olingo.client.core.edm.xml.AbstractEdmItem;

public abstract class AbstractXMLMetadata
extends AbstractEdmItem
implements XMLMetadata {
    private static final long serialVersionUID = -5141922932300533083L;
    protected final Edmx edmx;

    public AbstractXMLMetadata(Edmx edmx) {
        this.edmx = edmx;
    }

    public List<? extends Schema> getSchemas() {
        return this.edmx.getDataServices().getSchemas();
    }

    public Schema getSchema(int index) {
        return this.getSchemas().get(index);
    }

    public Schema getSchema(String key) {
        return this.getSchemaByNsOrAlias().get(key);
    }

    public Map<String, Schema> getSchemaByNsOrAlias() {
        HashMap<String, Schema> schemaByNsOrAlias = new HashMap<String, Schema>();
        for (Schema schema : this.getSchemas()) {
            schemaByNsOrAlias.put(schema.getNamespace(), schema);
            if (!StringUtils.isNotBlank((CharSequence)schema.getAlias())) continue;
            schemaByNsOrAlias.put(schema.getAlias(), schema);
        }
        return schemaByNsOrAlias;
    }
}

