/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.v4;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.api.edm.xml.v4.Annotation;
import org.apache.olingo.client.api.edm.xml.v4.Parameter;
import org.apache.olingo.client.core.edm.xml.AbstractEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.v4.AnnotationImpl;
import org.apache.olingo.client.core.edm.xml.v4.FunctionImpl;
import org.apache.olingo.client.core.edm.xml.v4.ParameterImpl;

public class FunctionDeserializer
extends AbstractEdmDeserializer<FunctionImpl> {
    @Override
    protected FunctionImpl doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        FunctionImpl functionImpl = new FunctionImpl();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                if ("Name".equals(jp.getCurrentName())) {
                    functionImpl.setName(jp.nextTextValue());
                } else if ("IsBound".equals(jp.getCurrentName())) {
                    functionImpl.setBound(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                } else if ("IsComposable".equals(jp.getCurrentName())) {
                    functionImpl.setComposable(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                } else if ("EntitySetPath".equals(jp.getCurrentName())) {
                    functionImpl.setEntitySetPath(jp.nextTextValue());
                } else if ("Parameter".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    functionImpl.getParameters().add((Parameter)jp.readValueAs(ParameterImpl.class));
                } else if ("ReturnType".equals(jp.getCurrentName())) {
                    functionImpl.setReturnType(this.parseReturnType(jp, "Function"));
                } else if ("Annotation".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    functionImpl.getAnnotations().add((Annotation)jp.readValueAs(AnnotationImpl.class));
                }
            }
            jp.nextToken();
        }
        return functionImpl;
    }
}

