/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.v4;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.api.edm.xml.OnDelete;
import org.apache.olingo.client.api.edm.xml.v4.Annotation;
import org.apache.olingo.client.api.edm.xml.v4.ReferentialConstraint;
import org.apache.olingo.client.core.edm.xml.AbstractEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.OnDeleteImpl;
import org.apache.olingo.client.core.edm.xml.v4.AnnotationImpl;
import org.apache.olingo.client.core.edm.xml.v4.NavigationPropertyImpl;
import org.apache.olingo.client.core.edm.xml.v4.ReferentialConstraintImpl;

public class NavigationPropertyDeserializer
extends AbstractEdmDeserializer<NavigationPropertyImpl> {
    @Override
    protected NavigationPropertyImpl doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        NavigationPropertyImpl property = new NavigationPropertyImpl();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                if ("Name".equals(jp.getCurrentName())) {
                    property.setName(jp.nextTextValue());
                } else if ("Type".equals(jp.getCurrentName())) {
                    property.setType(jp.nextTextValue());
                } else if ("Nullable".equals(jp.getCurrentName())) {
                    property.setNullable(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                } else if ("Partner".equals(jp.getCurrentName())) {
                    property.setPartner(jp.nextTextValue());
                } else if ("ContainsTarget".equals(jp.getCurrentName())) {
                    property.setContainsTarget(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                } else if ("ReferentialConstraint".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    property.getReferentialConstraints().add((ReferentialConstraint)jp.readValueAs(ReferentialConstraintImpl.class));
                } else if ("OnDelete".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    property.setOnDelete((OnDelete)jp.readValueAs(OnDeleteImpl.class));
                } else if ("Annotation".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    property.getAnnotations().add((Annotation)jp.readValueAs(AnnotationImpl.class));
                }
            }
            jp.nextToken();
        }
        return property;
    }
}

