/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.v4;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.core.edm.xml.AbstractEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.v4.ReturnTypeImpl;
import org.apache.olingo.commons.api.edm.geo.SRID;

public class ReturnTypeDeserializer
extends AbstractEdmDeserializer<ReturnTypeImpl> {
    @Override
    protected ReturnTypeImpl doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ReturnTypeImpl returnType = new ReturnTypeImpl();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                String srid;
                if ("Type".equals(jp.getCurrentName())) {
                    returnType.setType(jp.nextTextValue());
                } else if ("Nullable".equals(jp.getCurrentName())) {
                    returnType.setNullable(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                } else if ("MaxLength".equals(jp.getCurrentName())) {
                    String maxLenght = jp.nextTextValue();
                    returnType.setMaxLength(maxLenght.equalsIgnoreCase("max") ? Integer.MAX_VALUE : Integer.valueOf(maxLenght));
                } else if ("Precision".equals(jp.getCurrentName())) {
                    returnType.setPrecision(Integer.valueOf(jp.nextTextValue()));
                } else if ("Scale".equals(jp.getCurrentName())) {
                    String scale = jp.nextTextValue();
                    returnType.setScale(scale.equalsIgnoreCase("variable") ? 0 : Integer.valueOf(scale));
                } else if ("SRID".equals(jp.getCurrentName()) && (srid = jp.nextTextValue()) != null) {
                    returnType.setSrid(SRID.valueOf((String)srid));
                }
            }
            jp.nextToken();
        }
        return returnType;
    }
}

