/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.v4.annotation;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.apache.olingo.client.api.edm.xml.v4.annotation.DynamicAnnotationExpression;
import org.apache.olingo.client.core.edm.xml.AbstractEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.v4.AnnotationImpl;
import org.apache.olingo.client.core.edm.xml.v4.annotation.AbstractDynamicAnnotationExpression;
import org.apache.olingo.client.core.edm.xml.v4.annotation.IsOfImpl;
import org.apache.olingo.commons.api.edm.geo.SRID;

public class IsOfDeserializer
extends AbstractEdmDeserializer<IsOfImpl> {
    @Override
    protected IsOfImpl doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        IsOfImpl isof = new IsOfImpl();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                if ("Type".equals(jp.getCurrentName())) {
                    isof.setType(jp.nextTextValue());
                } else if ("Annotation".equals(jp.getCurrentName())) {
                    isof.getAnnotations().add(jp.readValueAs(AnnotationImpl.class));
                } else if ("MaxLength".equals(jp.getCurrentName())) {
                    String maxLenght = jp.nextTextValue();
                    isof.setMaxLength(maxLenght.equalsIgnoreCase("max") ? Integer.MAX_VALUE : Integer.valueOf(maxLenght));
                } else if ("Precision".equals(jp.getCurrentName())) {
                    isof.setPrecision(Integer.valueOf(jp.nextTextValue()));
                } else if ("Scale".equals(jp.getCurrentName())) {
                    String scale = jp.nextTextValue();
                    isof.setScale(scale.equalsIgnoreCase("variable") ? 0 : Integer.valueOf(scale));
                } else if ("SRID".equals(jp.getCurrentName())) {
                    String srid = jp.nextTextValue();
                    if (srid != null) {
                        isof.setSrid(SRID.valueOf((String)srid));
                    }
                } else {
                    isof.setValue((DynamicAnnotationExpression)jp.readValueAs(AbstractDynamicAnnotationExpression.class));
                }
            }
            jp.nextToken();
        }
        return isof;
    }
}

