/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.v4;

import org.apache.olingo.client.api.communication.header.HeaderName;
import org.apache.olingo.client.api.communication.header.ODataHeaders;
import org.apache.olingo.client.api.communication.request.batch.v4.BatchRequestFactory;
import org.apache.olingo.client.api.communication.request.cud.v4.CUDRequestFactory;
import org.apache.olingo.client.api.communication.request.cud.v4.UpdateType;
import org.apache.olingo.client.api.communication.request.invoke.InvokeRequestFactory;
import org.apache.olingo.client.api.communication.request.retrieve.v4.RetrieveRequestFactory;
import org.apache.olingo.client.api.communication.request.v4.AsyncRequestFactory;
import org.apache.olingo.client.api.serialization.v4.ODataBinder;
import org.apache.olingo.client.api.serialization.v4.ODataDeserializer;
import org.apache.olingo.client.api.serialization.v4.ODataReader;
import org.apache.olingo.client.api.uri.v4.FilterFactory;
import org.apache.olingo.client.api.uri.v4.SearchFactory;
import org.apache.olingo.client.api.uri.v4.URIBuilder;
import org.apache.olingo.client.api.v4.ODataClient;
import org.apache.olingo.client.core.AbstractODataClient;
import org.apache.olingo.client.core.communication.header.ODataHeadersImpl;
import org.apache.olingo.client.core.communication.request.batch.v4.BatchRequestFactoryImpl;
import org.apache.olingo.client.core.communication.request.cud.v4.CUDRequestFactoryImpl;
import org.apache.olingo.client.core.communication.request.invoke.v4.InvokeRequestFactoryImpl;
import org.apache.olingo.client.core.communication.request.retrieve.v4.RetrieveRequestFactoryImpl;
import org.apache.olingo.client.core.communication.request.v4.AsyncRequestFactoryImpl;
import org.apache.olingo.client.core.serialization.v4.ODataBinderImpl;
import org.apache.olingo.client.core.serialization.v4.ODataDeserializerImpl;
import org.apache.olingo.client.core.serialization.v4.ODataReaderImpl;
import org.apache.olingo.client.core.uri.v4.FilterFactoryImpl;
import org.apache.olingo.client.core.uri.v4.URIBuilderImpl;
import org.apache.olingo.client.core.v4.SearchFactoryImpl;
import org.apache.olingo.commons.api.domain.v4.ODataObjectFactory;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataSerializer;
import org.apache.olingo.commons.core.domain.v4.ODataObjectFactoryImpl;
import org.apache.olingo.commons.core.serialization.AtomSerializer;
import org.apache.olingo.commons.core.serialization.JsonSerializer;

public class ODataClientImpl
extends AbstractODataClient<UpdateType>
implements ODataClient {
    private final FilterFactory filterFactory = new FilterFactoryImpl(this.getServiceVersion());
    private final SearchFactory searchFactory = new SearchFactoryImpl();
    private final ODataReader reader = new ODataReaderImpl(this);
    private final ODataBinder binder = new ODataBinderImpl(this);
    private final ODataObjectFactory objectFactory = new ODataObjectFactoryImpl(this.getServiceVersion());
    private final AsyncRequestFactory asyncReqFact = new AsyncRequestFactoryImpl(this);
    private final RetrieveRequestFactory retrieveReqFact = new RetrieveRequestFactoryImpl(this);
    private final CUDRequestFactory cudReqFact = new CUDRequestFactoryImpl(this);
    private final InvokeRequestFactory invokeReqFact = new InvokeRequestFactoryImpl(this);
    private final BatchRequestFactory batchReqFact = new BatchRequestFactoryImpl(this);

    public ODataServiceVersion getServiceVersion() {
        return ODataServiceVersion.V40;
    }

    public ODataHeaders newVersionHeaders() {
        ODataHeadersImpl odataHeaders = new ODataHeadersImpl();
        odataHeaders.setHeader(HeaderName.odataMaxVersion, ODataServiceVersion.V40.toString());
        odataHeaders.setHeader(HeaderName.odataVersion, ODataServiceVersion.V40.toString());
        return odataHeaders;
    }

    public URIBuilder newURIBuilder(String serviceRoot) {
        return new URIBuilderImpl(this.getServiceVersion(), this.getConfiguration(), serviceRoot);
    }

    public FilterFactory getFilterFactory() {
        return this.filterFactory;
    }

    public SearchFactory getSearchFactory() {
        return this.searchFactory;
    }

    public ODataDeserializer getDeserializer(ODataFormat format) {
        return new ODataDeserializerImpl(this.getServiceVersion(), false, format);
    }

    public ODataSerializer getSerializer(ODataFormat format) {
        return format == ODataFormat.ATOM || format == ODataFormat.XML ? new AtomSerializer(this.getServiceVersion()) : new JsonSerializer(this.getServiceVersion(), false, format);
    }

    public ODataReader getReader() {
        return this.reader;
    }

    public ODataBinder getBinder() {
        return this.binder;
    }

    public ODataObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public AsyncRequestFactory getAsyncRequestFactory() {
        return this.asyncReqFact;
    }

    public RetrieveRequestFactory getRetrieveRequestFactory() {
        return this.retrieveReqFact;
    }

    public CUDRequestFactory getCUDRequestFactory() {
        return this.cudReqFact;
    }

    public InvokeRequestFactory getInvokeRequestFactory() {
        return this.invokeReqFact;
    }

    public BatchRequestFactory getBatchRequestFactory() {
        return this.batchReqFact;
    }
}

