/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.cud.v4;

import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.communication.request.cud.v4.ODataReferenceAddingRequest;
import org.apache.olingo.client.api.communication.response.v4.ODataReferenceAddingResponse;
import org.apache.olingo.client.api.serialization.ODataWriter;
import org.apache.olingo.client.core.communication.request.AbstractODataBasicRequest;
import org.apache.olingo.client.core.communication.response.AbstractODataResponse;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.api.serialization.ODataSerializerException;

public class ODataReferenceAddingRequestImpl
extends AbstractODataBasicRequest<ODataReferenceAddingResponse>
implements ODataReferenceAddingRequest {
    final ResWrap<URI> reference;

    ODataReferenceAddingRequestImpl(CommonODataClient<?> odataClient, HttpMethod method, URI uri, ResWrap<URI> reference) {
        super(odataClient, method, uri);
        this.reference = reference;
    }

    @Override
    public ODataFormat getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultPubFormat();
    }

    @Override
    protected InputStream getPayload() {
        if (this.reference == null) {
            return null;
        }
        ODataWriter writer = this.odataClient.getWriter();
        try {
            return writer.writeReference(this.reference, ODataFormat.fromString((String)this.getContentType()));
        }
        catch (ODataSerializerException e) {
            LOG.warn("Error serializing reference {}", this.reference);
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataReferenceAddingResponse execute() {
        InputStream input = this.getPayload();
        ((HttpEntityEnclosingRequestBase)this.request).setEntity(URIUtils.buildInputStreamEntity(this.odataClient, input));
        try {
            ODataReferenceAddingResponseImpl oDataReferenceAddingResponseImpl = new ODataReferenceAddingResponseImpl(this.odataClient, this.httpClient, this.doExecute());
            return oDataReferenceAddingResponseImpl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    private class ODataReferenceAddingResponseImpl
    extends AbstractODataResponse
    implements ODataReferenceAddingResponse {
        private ODataReferenceAddingResponseImpl(CommonODataClient<?> odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.close();
        }
    }
}

