/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve;

import java.net.URI;
import org.apache.http.client.HttpClient;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.EdmMetadataRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.edm.xml.XMLMetadata;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractMetadataRequestImpl;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractODataRetrieveRequest;
import org.apache.olingo.commons.api.edm.Edm;

class EdmMetadataRequestImpl
extends AbstractMetadataRequestImpl<Edm>
implements EdmMetadataRequest {
    private final String serviceRoot;
    private EdmMetadataResponseImpl privateResponse;

    EdmMetadataRequestImpl(CommonODataClient<?> odataClient, String serviceRoot, URI uri) {
        super(odataClient, uri);
        this.serviceRoot = serviceRoot;
    }

    private EdmMetadataResponseImpl getPrivateResponse() {
        if (this.privateResponse == null) {
            ODataRetrieveResponse xmlMetadataResponse = (ODataRetrieveResponse)this.odataClient.getRetrieveRequestFactory().getXMLMetadataRequest(this.serviceRoot).execute();
            this.privateResponse = new EdmMetadataResponseImpl(this.odataClient, this.httpClient, xmlMetadataResponse);
        }
        return this.privateResponse;
    }

    public XMLMetadata getXMLMetadata() {
        return this.getPrivateResponse().getXMLMetadata();
    }

    @Override
    public ODataRetrieveResponse<Edm> execute() {
        return this.getPrivateResponse();
    }

    private class EdmMetadataResponseImpl
    extends AbstractODataRetrieveRequest.AbstractODataRetrieveResponse {
        private final ODataRetrieveResponse<XMLMetadata> xmlMetadataResponse;
        private XMLMetadata metadata;

        private EdmMetadataResponseImpl(CommonODataClient<?> odataClient, HttpClient httpClient, ODataRetrieveResponse<XMLMetadata> xmlMetadataResponse) {
            super(odataClient, httpClient, null);
            this.metadata = null;
            this.xmlMetadataResponse = xmlMetadataResponse;
        }

        @Override
        public void close() {
            super.close();
            this.xmlMetadataResponse.close();
        }

        @Override
        public int getStatusCode() {
            return this.xmlMetadataResponse.getStatusCode();
        }

        @Override
        public String getStatusMessage() {
            return this.xmlMetadataResponse.getStatusMessage();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public XMLMetadata getXMLMetadata() {
            if (this.metadata == null) {
                try {
                    this.metadata = (XMLMetadata)this.xmlMetadataResponse.getBody();
                }
                finally {
                    this.close();
                }
            }
            return this.metadata;
        }

        public Edm getBody() {
            return this.odataClient.getReader().readMetadata(this.getXMLMetadata().getSchemaByNsOrAlias());
        }
    }
}

