/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.data;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.data.ServiceDocument;
import org.apache.olingo.client.core.data.ServiceDocumentImpl;
import org.apache.olingo.client.core.data.ServiceDocumentItemImpl;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;
import org.apache.olingo.commons.core.serialization.JsonDeserializer;

public class JSONServiceDocumentDeserializer
extends JsonDeserializer {
    public JSONServiceDocumentDeserializer(ODataServiceVersion version, boolean serverMode) {
        super(version, serverMode);
    }

    protected ResWrap<ServiceDocument> doDeserialize(JsonParser parser) throws IOException {
        URI contextURL;
        String metadataETag;
        ObjectNode tree = (ObjectNode)parser.getCodec().readTree(parser);
        ServiceDocumentImpl serviceDocument = new ServiceDocumentImpl();
        if (tree.hasNonNull("@odata.metadataEtag")) {
            metadataETag = tree.get("@odata.metadataEtag").textValue();
            tree.remove("@odata.metadataEtag");
        } else {
            metadataETag = null;
        }
        if (tree.hasNonNull("@odata.context")) {
            contextURL = URI.create(tree.get("@odata.context").textValue());
            tree.remove("@odata.context");
        } else if (tree.hasNonNull("odata.metadata")) {
            contextURL = URI.create(tree.get("odata.metadata").textValue());
            tree.remove("odata.metadata");
        } else {
            contextURL = null;
        }
        serviceDocument.setMetadata(contextURL == null ? null : contextURL.toASCIIString());
        Iterator itor = tree.get("value").elements();
        while (itor.hasNext()) {
            String kind;
            JsonNode node = (JsonNode)itor.next();
            ServiceDocumentItemImpl item = new ServiceDocumentItemImpl();
            item.setName(node.get("name").asText());
            item.setUrl(node.get("url").asText());
            String string = kind = node.has("kind") ? node.get("kind").asText() : null;
            if (StringUtils.isBlank((CharSequence)kind) || "EntitySet".equals(kind)) {
                serviceDocument.getEntitySets().add(item);
                continue;
            }
            if ("Singleton".equals(kind)) {
                serviceDocument.getSingletons().add(item);
                continue;
            }
            if ("FunctionImport".equals(kind)) {
                serviceDocument.getFunctionImports().add(item);
                continue;
            }
            if (!"ServiceDocument".equals(kind)) continue;
            serviceDocument.getRelatedServiceDocuments().add(item);
        }
        return new ResWrap(contextURL, metadataETag, (Object)serviceDocument);
    }

    public ResWrap<ServiceDocument> toServiceDocument(InputStream input) throws ODataDeserializerException {
        try {
            JsonParser parser = new JsonFactory((ObjectCodec)new ObjectMapper()).createParser(input);
            return this.doDeserialize(parser);
        }
        catch (IOException e) {
            throw new ODataDeserializerException((Throwable)e);
        }
    }
}

