/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.olingo.client.api.edm.xml.ComplexType;
import org.apache.olingo.client.api.edm.xml.PropertyRef;
import org.apache.olingo.client.api.edm.xml.Schema;
import org.apache.olingo.client.api.edm.xml.v4.Annotatable;
import org.apache.olingo.client.api.edm.xml.v4.EntityType;
import org.apache.olingo.client.core.edm.EdmAnnotationHelperImpl;
import org.apache.olingo.client.core.edm.EdmKeyPropertyRefImpl;
import org.apache.olingo.client.core.edm.EdmStructuredTypeHelperImpl;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.AbstractEdmEntityType;
import org.apache.olingo.commons.core.edm.EdmAnnotationHelper;
import org.apache.olingo.commons.core.edm.EdmStructuredTypeHelper;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;

public class EdmEntityTypeImpl
extends AbstractEdmEntityType {
    private final EdmStructuredTypeHelper typeHelper;
    private EdmAnnotationHelper annotationHelper;

    public static EdmEntityTypeImpl getInstance(Edm edm, FullQualifiedName fqn, List<? extends Schema> xmlSchemas, org.apache.olingo.client.api.edm.xml.EntityType entityType) {
        FullQualifiedName baseTypeName = entityType.getBaseType() == null ? null : new EdmTypeInfo.Builder().setTypeExpression(entityType.getBaseType()).build().getFullQualifiedName();
        EdmEntityTypeImpl instance = new EdmEntityTypeImpl(edm, fqn, baseTypeName, xmlSchemas, entityType);
        instance.baseType = instance.buildBaseType(baseTypeName);
        if (instance.baseType == null) {
            ArrayList<EdmKeyPropertyRefImpl> edmKey;
            instance.entityBaseType = null;
            if (entityType.isAbstractEntityType() && entityType.getKey() == null) {
                edmKey = new ArrayList<EdmKeyPropertyRefImpl>();
            } else {
                edmKey = new ArrayList(entityType.getKey().getPropertyRefs().size());
                for (PropertyRef ref : entityType.getKey().getPropertyRefs()) {
                    edmKey.add(new EdmKeyPropertyRefImpl((EdmEntityType)instance, ref));
                }
            }
            instance.setEdmKeyPropertyRef(edmKey);
        } else {
            instance.entityBaseType = (EdmEntityType)instance.baseType;
        }
        return instance;
    }

    private EdmEntityTypeImpl(Edm edm, FullQualifiedName fqn, FullQualifiedName baseTypeName, List<? extends Schema> xmlSchemas, org.apache.olingo.client.api.edm.xml.EntityType entityType) {
        super(edm, fqn, baseTypeName, entityType.isHasStream());
        this.typeHelper = new EdmStructuredTypeHelperImpl(edm, this.getFullQualifiedName(), xmlSchemas, (ComplexType)entityType);
        if (entityType instanceof EntityType) {
            this.annotationHelper = new EdmAnnotationHelperImpl(edm, (Annotatable)((EntityType)entityType));
        }
    }

    protected Map<String, EdmProperty> getProperties() {
        return this.typeHelper.getProperties();
    }

    protected Map<String, EdmNavigationProperty> getNavigationProperties() {
        return this.typeHelper.getNavigationProperties();
    }

    public boolean isOpenType() {
        return this.typeHelper.isOpenType();
    }

    public boolean isAbstract() {
        return this.typeHelper.isAbstract();
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        return this.annotationHelper.getAnnotation(term);
    }

    public List<EdmAnnotation> getAnnotations() {
        return this.annotationHelper.getAnnotations();
    }
}

