/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.client.api.edm.xml.v4.Annotatable;
import org.apache.olingo.client.api.edm.xml.v4.NavigationProperty;
import org.apache.olingo.client.api.edm.xml.v4.ReferentialConstraint;
import org.apache.olingo.client.core.edm.EdmAnnotationHelperImpl;
import org.apache.olingo.client.core.edm.EdmReferentialConstraintImpl;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmReferentialConstraint;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.AbstractEdmNavigationProperty;
import org.apache.olingo.commons.core.edm.EdmAnnotationHelper;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;

public class EdmNavigationPropertyImpl
extends AbstractEdmNavigationProperty {
    private final FullQualifiedName structuredTypeName;
    private final NavigationProperty navigationProperty;
    private final EdmTypeInfo edmTypeInfo;
    private final EdmAnnotationHelper helper;
    private List<EdmReferentialConstraint> referentialConstraints;

    public EdmNavigationPropertyImpl(Edm edm, FullQualifiedName structuredTypeName, NavigationProperty navigationProperty) {
        super(edm, navigationProperty.getName());
        this.structuredTypeName = structuredTypeName;
        this.navigationProperty = navigationProperty;
        this.edmTypeInfo = new EdmTypeInfo.Builder().setTypeExpression(navigationProperty.getType()).build();
        this.helper = new EdmAnnotationHelperImpl(edm, (Annotatable)navigationProperty);
    }

    protected FullQualifiedName getTypeFQN() {
        return this.edmTypeInfo.getFullQualifiedName();
    }

    protected String internatGetPartner() {
        return this.navigationProperty.getPartner();
    }

    public boolean isCollection() {
        return this.edmTypeInfo.isCollection();
    }

    public Boolean isNullable() {
        return this.navigationProperty.isNullable();
    }

    public Boolean containsTarget() {
        return this.navigationProperty.isContainsTarget();
    }

    public String getReferencingPropertyName(String referencedPropertyName) {
        for (EdmReferentialConstraint constraint : this.getReferentialConstraints()) {
            if (!constraint.getReferencedPropertyName().equals(referencedPropertyName)) continue;
            return constraint.getPropertyName();
        }
        return null;
    }

    public List<EdmReferentialConstraint> getReferentialConstraints() {
        if (this.referentialConstraints == null) {
            List providerConstraints = this.navigationProperty.getReferentialConstraints();
            this.referentialConstraints = new ArrayList<EdmReferentialConstraint>();
            if (providerConstraints != null) {
                for (ReferentialConstraint constraint : providerConstraints) {
                    this.referentialConstraints.add((EdmReferentialConstraint)new EdmReferentialConstraintImpl(this.edm, constraint));
                }
            }
        }
        return this.referentialConstraints;
    }

    public FullQualifiedName getAnnotationsTargetFQN() {
        return this.structuredTypeName;
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        return this.helper.getAnnotation(term);
    }

    public List<EdmAnnotation> getAnnotations() {
        return this.helper.getAnnotations();
    }
}

