/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm;

import java.util.Collections;
import java.util.List;
import org.apache.olingo.client.api.edm.xml.CommonParameter;
import org.apache.olingo.client.api.edm.xml.v4.Annotatable;
import org.apache.olingo.client.api.edm.xml.v4.Parameter;
import org.apache.olingo.client.core.edm.EdmAnnotationHelperImpl;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmMapping;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.core.edm.AbstractEdmParameter;
import org.apache.olingo.commons.core.edm.EdmAnnotationHelper;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;

public class EdmParameterImpl
extends AbstractEdmParameter {
    private final CommonParameter parameter;
    private final EdmTypeInfo typeInfo;
    private EdmAnnotationHelper helper;

    public EdmParameterImpl(Edm edm, CommonParameter parameter) {
        super(edm, parameter.getName(), new FullQualifiedName(parameter.getType()));
        this.parameter = parameter;
        this.typeInfo = new EdmTypeInfo.Builder().setEdm(edm).setTypeExpression(parameter.getType()).build();
        if (parameter instanceof Parameter) {
            this.helper = new EdmAnnotationHelperImpl(edm, (Annotatable)((Parameter)parameter));
        }
    }

    public boolean isCollection() {
        return this.typeInfo.isCollection();
    }

    public EdmMapping getMapping() {
        throw new UnsupportedOperationException("Not supported in client code.");
    }

    public Boolean isNullable() {
        return this.parameter.isNullable();
    }

    public Integer getMaxLength() {
        return this.parameter.getMaxLength();
    }

    public Integer getPrecision() {
        return this.parameter.getPrecision();
    }

    public Integer getScale() {
        return this.parameter.getScale();
    }

    public SRID getSrid() {
        return this.parameter instanceof Parameter ? ((Parameter)this.parameter).getSrid() : null;
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        return this.helper == null ? null : this.helper.getAnnotation(term);
    }

    public List<EdmAnnotation> getAnnotations() {
        return this.helper == null ? Collections.emptyList() : this.helper.getAnnotations();
    }
}

