/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm;

import java.util.Collections;
import java.util.List;
import org.apache.olingo.client.api.edm.xml.CommonProperty;
import org.apache.olingo.client.api.edm.xml.v4.Annotatable;
import org.apache.olingo.client.api.edm.xml.v4.Property;
import org.apache.olingo.client.core.edm.EdmAnnotationHelperImpl;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmMapping;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.core.edm.AbstractEdmProperty;
import org.apache.olingo.commons.core.edm.EdmAnnotationHelper;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;

public class EdmPropertyImpl
extends AbstractEdmProperty {
    private final FullQualifiedName structuredTypeName;
    private final CommonProperty property;
    private final EdmTypeInfo typeInfo;
    private EdmAnnotationHelper helper;

    public EdmPropertyImpl(Edm edm, FullQualifiedName structuredTypeName, CommonProperty property) {
        super(edm, property.getName());
        this.structuredTypeName = structuredTypeName;
        this.property = property;
        this.typeInfo = new EdmTypeInfo.Builder().setEdm(edm).setTypeExpression(property.getType()).build();
        if (property instanceof Property) {
            this.helper = new EdmAnnotationHelperImpl(edm, (Annotatable)((Property)property));
        }
    }

    protected EdmTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public EdmMapping getMapping() {
        throw new UnsupportedOperationException("Not supported in client code.");
    }

    public String getMimeType() {
        throw new UnsupportedOperationException("Not supported in client code.");
    }

    public Boolean isNullable() {
        return this.property.isNullable();
    }

    public Integer getMaxLength() {
        return this.property.getMaxLength();
    }

    public Integer getPrecision() {
        return this.property.getPrecision();
    }

    public Integer getScale() {
        return this.property.getScale();
    }

    public Boolean isUnicode() {
        return this.property.isUnicode();
    }

    public String getDefaultValue() {
        return this.property.getDefaultValue();
    }

    public SRID getSrid() {
        return this.property instanceof Property ? ((Property)this.property).getSrid() : null;
    }

    public FullQualifiedName getAnnotationsTargetFQN() {
        return this.structuredTypeName;
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        return this.helper == null ? null : this.helper.getAnnotation(term);
    }

    public List<EdmAnnotation> getAnnotations() {
        return this.helper == null ? Collections.emptyList() : this.helper.getAnnotations();
    }
}

