/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.api.edm.xml.v3.ParameterMode;
import org.apache.olingo.client.api.edm.xml.v4.Annotation;
import org.apache.olingo.client.core.edm.xml.AbstractEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.AbstractParameter;
import org.apache.olingo.client.core.edm.xml.v3.ParameterImpl;
import org.apache.olingo.client.core.edm.xml.v4.AnnotationImpl;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.edm.geo.SRID;

public class ParameterDeserializer
extends AbstractEdmDeserializer<AbstractParameter> {
    @Override
    protected AbstractParameter doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        AbstractParameter parameter;
        AbstractParameter abstractParameter = parameter = ODataServiceVersion.V30 == this.version ? new ParameterImpl() : new org.apache.olingo.client.core.edm.xml.v4.ParameterImpl();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                if ("Name".equals(jp.getCurrentName())) {
                    parameter.setName(jp.nextTextValue());
                } else if ("Type".equals(jp.getCurrentName())) {
                    parameter.setType(jp.nextTextValue());
                } else if ("Nullable".equals(jp.getCurrentName())) {
                    parameter.setNullable(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                } else if ("MaxLength".equals(jp.getCurrentName())) {
                    String maxLenght = jp.nextTextValue();
                    parameter.setMaxLength(maxLenght.equalsIgnoreCase("max") ? Integer.MAX_VALUE : Integer.valueOf(maxLenght));
                } else if ("Precision".equals(jp.getCurrentName())) {
                    parameter.setPrecision(Integer.valueOf(jp.nextTextValue()));
                } else if ("Scale".equals(jp.getCurrentName())) {
                    String scale = jp.nextTextValue();
                    parameter.setScale(scale.equalsIgnoreCase("variable") ? 0 : Integer.valueOf(scale));
                } else if ("Mode".equals(jp.getCurrentName())) {
                    ((ParameterImpl)parameter).setMode(ParameterMode.valueOf((String)jp.nextTextValue()));
                } else if ("SRID".equals(jp.getCurrentName())) {
                    String srid = jp.nextTextValue();
                    if (srid != null) {
                        ((org.apache.olingo.client.core.edm.xml.v4.ParameterImpl)parameter).setSrid(SRID.valueOf((String)srid));
                    }
                } else if ("Annotation".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    ((org.apache.olingo.client.core.edm.xml.v4.ParameterImpl)parameter).getAnnotations().add((Annotation)jp.readValueAs(AnnotationImpl.class));
                }
            }
            jp.nextToken();
        }
        return parameter;
    }
}

