/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.v3;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.api.edm.xml.v3.Parameter;
import org.apache.olingo.client.core.edm.xml.AbstractEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.v3.FunctionImportImpl;
import org.apache.olingo.client.core.edm.xml.v3.ParameterImpl;

public class FunctionImportDeserializer
extends AbstractEdmDeserializer<FunctionImportImpl> {
    @Override
    protected FunctionImportImpl doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        FunctionImportImpl funcImp = new FunctionImportImpl();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                if ("Name".equals(jp.getCurrentName())) {
                    funcImp.setName(jp.nextTextValue());
                } else if ("ReturnType".equals(jp.getCurrentName())) {
                    funcImp.setReturnType(jp.nextTextValue());
                } else if ("EntitySet".equals(jp.getCurrentName())) {
                    funcImp.setEntitySet(jp.nextTextValue());
                } else if ("EntitySetPath".equals(jp.getCurrentName())) {
                    funcImp.setEntitySetPath(jp.nextTextValue());
                } else if ("IsComposable".equals(jp.getCurrentName())) {
                    funcImp.setComposable(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                } else if ("IsSideEffecting".equals(jp.getCurrentName())) {
                    funcImp.setSideEffecting(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                } else if ("IsBindable".equals(jp.getCurrentName())) {
                    funcImp.setBindable(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                } else if ("IsAlwaysBindable".equals(jp.getCurrentName())) {
                    funcImp.setAlwaysBindable(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                } else if ("HttpMethod".equals(jp.getCurrentName())) {
                    funcImp.setHttpMethod(jp.nextTextValue());
                } else if ("Parameter".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    funcImp.getParameters().add((Parameter)jp.readValueAs(ParameterImpl.class));
                }
            }
            jp.nextToken();
        }
        return funcImp;
    }
}

