/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.v4;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.apache.olingo.client.api.edm.xml.v4.Annotation;
import org.apache.olingo.client.api.edm.xml.v4.NavigationPropertyBinding;
import org.apache.olingo.client.core.edm.xml.AbstractEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.v4.AnnotationImpl;
import org.apache.olingo.client.core.edm.xml.v4.NavigationPropertyBindingImpl;
import org.apache.olingo.client.core.edm.xml.v4.SingletonImpl;

public class SingletonDeserializer
extends AbstractEdmDeserializer<SingletonImpl> {
    @Override
    protected SingletonImpl doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        SingletonImpl singleton = new SingletonImpl();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                if ("Name".equals(jp.getCurrentName())) {
                    singleton.setName(jp.nextTextValue());
                } else if ("Type".equals(jp.getCurrentName())) {
                    singleton.setEntityType(jp.nextTextValue());
                } else if ("NavigationPropertyBinding".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    singleton.getNavigationPropertyBindings().add((NavigationPropertyBinding)jp.readValueAs(NavigationPropertyBindingImpl.class));
                } else if ("Annotation".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    singleton.getAnnotations().add((Annotation)jp.readValueAs(AnnotationImpl.class));
                }
            }
            jp.nextToken();
        }
        return singleton;
    }
}

