/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.v4.annotation;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.olingo.client.api.edm.xml.v4.annotation.AnnotationPath;
import org.apache.olingo.client.api.edm.xml.v4.annotation.Apply;
import org.apache.olingo.client.api.edm.xml.v4.annotation.Cast;
import org.apache.olingo.client.api.edm.xml.v4.annotation.Collection;
import org.apache.olingo.client.api.edm.xml.v4.annotation.DynamicAnnotationExpression;
import org.apache.olingo.client.api.edm.xml.v4.annotation.If;
import org.apache.olingo.client.api.edm.xml.v4.annotation.IsOf;
import org.apache.olingo.client.api.edm.xml.v4.annotation.LabeledElement;
import org.apache.olingo.client.api.edm.xml.v4.annotation.NavigationPropertyPath;
import org.apache.olingo.client.api.edm.xml.v4.annotation.Null;
import org.apache.olingo.client.api.edm.xml.v4.annotation.Path;
import org.apache.olingo.client.api.edm.xml.v4.annotation.PropertyPath;
import org.apache.olingo.client.api.edm.xml.v4.annotation.Record;
import org.apache.olingo.client.api.edm.xml.v4.annotation.TwoParamsOpDynamicAnnotationExpression;
import org.apache.olingo.client.api.edm.xml.v4.annotation.UrlRef;
import org.apache.olingo.client.core.edm.xml.AbstractEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.v4.annotation.AbstractAnnotationExpression;
import org.apache.olingo.client.core.edm.xml.v4.annotation.AbstractDynamicAnnotationExpression;
import org.apache.olingo.client.core.edm.xml.v4.annotation.AbstractElementOrAttributeExpression;
import org.apache.olingo.client.core.edm.xml.v4.annotation.ApplyImpl;
import org.apache.olingo.client.core.edm.xml.v4.annotation.CastImpl;
import org.apache.olingo.client.core.edm.xml.v4.annotation.CollectionImpl;
import org.apache.olingo.client.core.edm.xml.v4.annotation.IfImpl;
import org.apache.olingo.client.core.edm.xml.v4.annotation.IsOfImpl;
import org.apache.olingo.client.core.edm.xml.v4.annotation.LabeledElementImpl;
import org.apache.olingo.client.core.edm.xml.v4.annotation.NotImpl;
import org.apache.olingo.client.core.edm.xml.v4.annotation.NullImpl;
import org.apache.olingo.client.core.edm.xml.v4.annotation.RecordImpl;
import org.apache.olingo.client.core.edm.xml.v4.annotation.TwoParamsOpDynamicAnnotationExpressionImpl;
import org.apache.olingo.client.core.edm.xml.v4.annotation.UrlRefImpl;

public class DynamicAnnotationExpressionDeserializer
extends AbstractEdmDeserializer<AbstractDynamicAnnotationExpression> {
    private static final String[] EL_OR_ATTR = new String[]{AnnotationPath.class.getSimpleName(), NavigationPropertyPath.class.getSimpleName(), Path.class.getSimpleName(), PropertyPath.class.getSimpleName()};
    private static final String APPLY = Apply.class.getSimpleName();
    private static final String CAST = Cast.class.getSimpleName();
    private static final String COLLECTION = Collection.class.getSimpleName();
    private static final String IF = If.class.getSimpleName();
    private static final String IS_OF = IsOf.class.getSimpleName();
    private static final String LABELED_ELEMENT = LabeledElement.class.getSimpleName();
    private static final String NULL = Null.class.getSimpleName();
    private static final String RECORD = Record.class.getSimpleName();
    private static final String URL_REF = UrlRef.class.getSimpleName();

    private AbstractElementOrAttributeExpression getElementOrAttributeExpressio(String simpleClassName) throws JsonParseException {
        try {
            Class elOrAttrClass = ClassUtils.getClass((String)(((Object)((Object)this)).getClass().getPackage().getName() + "." + simpleClassName + "Impl"));
            return (AbstractElementOrAttributeExpression)elOrAttrClass.newInstance();
        }
        catch (Exception e) {
            throw new JsonParseException("Could not instantiate " + simpleClassName, JsonLocation.NA, (Throwable)e);
        }
    }

    private AbstractAnnotationExpression parseConstOrEnumExpression(JsonParser jp) throws IOException {
        AbstractAnnotationExpression result = this.isAnnotationConstExprConstruct(jp) ? this.parseAnnotationConstExprConstruct(jp) : (AbstractAnnotationExpression)jp.readValueAs(AbstractDynamicAnnotationExpression.class);
        jp.nextToken();
        return result;
    }

    @Override
    protected AbstractDynamicAnnotationExpression doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        AbstractDynamicAnnotationExpression expression = null;
        if ("Not".equals(jp.getCurrentName())) {
            NotImpl not = new NotImpl();
            jp.nextToken();
            while (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                jp.nextToken();
            }
            not.setExpression((DynamicAnnotationExpression)jp.readValueAs(AbstractDynamicAnnotationExpression.class));
            while (jp.getCurrentToken() != JsonToken.END_OBJECT || !jp.getCurrentName().equals("Not")) {
                jp.nextToken();
            }
            expression = not;
        } else if (TwoParamsOpDynamicAnnotationExpression.Type.fromString((String)jp.getCurrentName()) != null) {
            TwoParamsOpDynamicAnnotationExpressionImpl dynExprDoubleParamOp = new TwoParamsOpDynamicAnnotationExpressionImpl();
            dynExprDoubleParamOp.setType(TwoParamsOpDynamicAnnotationExpression.Type.fromString((String)jp.getCurrentName()));
            jp.nextToken();
            while (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                jp.nextToken();
            }
            dynExprDoubleParamOp.setLeftExpression((DynamicAnnotationExpression)jp.readValueAs(AbstractDynamicAnnotationExpression.class));
            dynExprDoubleParamOp.setRightExpression((DynamicAnnotationExpression)jp.readValueAs(AbstractDynamicAnnotationExpression.class));
            while (jp.getCurrentToken() != JsonToken.END_OBJECT || !jp.getCurrentName().equals(dynExprDoubleParamOp.getType().name())) {
                jp.nextToken();
            }
            expression = dynExprDoubleParamOp;
        } else if (ArrayUtils.contains((Object[])EL_OR_ATTR, (Object)jp.getCurrentName())) {
            AbstractElementOrAttributeExpression elOrAttr = this.getElementOrAttributeExpressio(jp.getCurrentName());
            elOrAttr.setValue(jp.nextTextValue());
            expression = elOrAttr;
        } else if (APPLY.equals(jp.getCurrentName())) {
            jp.nextToken();
            expression = (AbstractDynamicAnnotationExpression)jp.readValueAs(ApplyImpl.class);
        } else if (CAST.equals(jp.getCurrentName())) {
            jp.nextToken();
            expression = (AbstractDynamicAnnotationExpression)jp.readValueAs(CastImpl.class);
        } else if (COLLECTION.equals(jp.getCurrentName())) {
            jp.nextToken();
            expression = (AbstractDynamicAnnotationExpression)jp.readValueAs(CollectionImpl.class);
        } else if (IF.equals(jp.getCurrentName())) {
            jp.nextToken();
            jp.nextToken();
            IfImpl _if = new IfImpl();
            _if.setGuard(this.parseConstOrEnumExpression(jp));
            _if.setThen(this.parseConstOrEnumExpression(jp));
            _if.setElse(this.parseConstOrEnumExpression(jp));
            expression = _if;
        } else if (IS_OF.equals(jp.getCurrentName())) {
            jp.nextToken();
            expression = (AbstractDynamicAnnotationExpression)jp.readValueAs(IsOfImpl.class);
        } else if (LABELED_ELEMENT.equals(jp.getCurrentName())) {
            jp.nextToken();
            expression = (AbstractDynamicAnnotationExpression)jp.readValueAs(LabeledElementImpl.class);
        } else if (NULL.equals(jp.getCurrentName())) {
            jp.nextToken();
            expression = (AbstractDynamicAnnotationExpression)jp.readValueAs(NullImpl.class);
        } else if (RECORD.equals(jp.getCurrentName())) {
            jp.nextToken();
            expression = (AbstractDynamicAnnotationExpression)jp.readValueAs(RecordImpl.class);
        } else if (URL_REF.equals(jp.getCurrentName())) {
            jp.nextToken();
            expression = (AbstractDynamicAnnotationExpression)jp.readValueAs(UrlRefImpl.class);
        }
        return expression;
    }
}

