/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.v4.annotation;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.apache.olingo.client.api.edm.xml.v4.annotation.PropertyValue;
import org.apache.olingo.client.core.edm.xml.AbstractEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.v4.AnnotationImpl;
import org.apache.olingo.client.core.edm.xml.v4.annotation.PropertyValueImpl;
import org.apache.olingo.client.core.edm.xml.v4.annotation.RecordImpl;

public class RecordDeserializer
extends AbstractEdmDeserializer<RecordImpl> {
    @Override
    protected RecordImpl doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        RecordImpl record = new RecordImpl();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                if ("Type".equals(jp.getCurrentName())) {
                    record.setType(jp.nextTextValue());
                } else if ("Annotation".equals(jp.getCurrentName())) {
                    record.getAnnotations().add(jp.readValueAs(AnnotationImpl.class));
                } else {
                    record.getPropertyValues().add((PropertyValue)jp.readValueAs(PropertyValueImpl.class));
                }
            }
            jp.nextToken();
        }
        return record;
    }
}

