/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import com.fasterxml.aalto.stax.InputFactoryImpl;
import com.fasterxml.aalto.stax.OutputFactoryImpl;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntitySet;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.domain.ODataError;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataDeserializer;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;
import org.apache.olingo.commons.core.serialization.AtomDeserializer;
import org.apache.olingo.commons.core.serialization.JsonDeserializer;

public abstract class AbstractODataDeserializer {
    protected final ODataServiceVersion version;
    protected final ODataDeserializer deserializer;

    public AbstractODataDeserializer(ODataServiceVersion version, boolean serverMode, ODataFormat format) {
        this.version = version;
        this.deserializer = format == ODataFormat.XML || format == ODataFormat.ATOM ? new AtomDeserializer(version) : new JsonDeserializer(version, serverMode);
    }

    public ResWrap<EntitySet> toEntitySet(InputStream input) throws ODataDeserializerException {
        return this.deserializer.toEntitySet(input);
    }

    public ResWrap<Entity> toEntity(InputStream input) throws ODataDeserializerException {
        return this.deserializer.toEntity(input);
    }

    public ResWrap<Property> toProperty(InputStream input) throws ODataDeserializerException {
        return this.deserializer.toProperty(input);
    }

    public ODataError toError(InputStream input) throws ODataDeserializerException {
        return this.deserializer.toError(input);
    }

    protected XmlMapper getXmlMapper() {
        XmlMapper xmlMapper = new XmlMapper(new XmlFactory((XMLInputFactory)new InputFactoryImpl(), (XMLOutputFactory)new OutputFactoryImpl()), new JacksonXmlModule());
        xmlMapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ODataServiceVersion.class, (Object)this.version).addValue(Boolean.class, (Object)Boolean.FALSE));
        xmlMapper.addHandler(new DeserializationProblemHandler(){

            public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser jp, com.fasterxml.jackson.databind.JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException, JsonProcessingException {
                ctxt.getParser().skipChildren();
                return true;
            }
        });
        return xmlMapper;
    }
}

