/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.data.ServiceDocument;
import org.apache.olingo.client.api.domain.ODataEntitySetIterator;
import org.apache.olingo.client.api.edm.xml.Schema;
import org.apache.olingo.client.api.edm.xml.XMLMetadata;
import org.apache.olingo.client.api.serialization.CommonODataReader;
import org.apache.olingo.client.core.edm.EdmClientImpl;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.domain.CommonODataEntity;
import org.apache.olingo.commons.api.domain.CommonODataEntitySet;
import org.apache.olingo.commons.api.domain.CommonODataProperty;
import org.apache.olingo.commons.api.domain.ODataError;
import org.apache.olingo.commons.api.domain.ODataServiceDocument;
import org.apache.olingo.commons.api.domain.ODataValue;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractODataReader
implements CommonODataReader {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractODataReader.class);
    protected final CommonODataClient<?> client;

    protected AbstractODataReader(CommonODataClient<?> client) {
        this.client = client;
    }

    public Edm readMetadata(InputStream input) {
        return this.readMetadata(this.client.getDeserializer(ODataFormat.XML).toMetadata(input).getSchemaByNsOrAlias());
    }

    public Edm readMetadata(Map<String, Schema> xmlSchemas) {
        return new EdmClientImpl(this.client.getServiceVersion(), xmlSchemas);
    }

    public ODataServiceDocument readServiceDocument(InputStream input, ODataFormat format) throws ODataDeserializerException {
        return this.client.getBinder().getODataServiceDocument((ServiceDocument)this.client.getDeserializer(format).toServiceDocument(input).getPayload());
    }

    public ODataError readError(InputStream inputStream, ODataFormat format) throws ODataDeserializerException {
        return this.client.getDeserializer(format).toError(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ResWrap<T> read(InputStream src, String format, Class<T> reference) throws ODataDeserializerException {
        ResWrap res;
        block14: {
            try {
                if (ODataEntitySetIterator.class.isAssignableFrom(reference)) {
                    res = new ResWrap((URI)null, null, reference.cast(new ODataEntitySetIterator(this.client, src, ODataFormat.fromString((String)format))));
                    break block14;
                }
                if (CommonODataEntitySet.class.isAssignableFrom(reference)) {
                    ResWrap resource = this.client.getDeserializer(ODataFormat.fromString((String)format)).toEntitySet(src);
                    res = new ResWrap(resource.getContextURL(), resource.getMetadataETag(), reference.cast(this.client.getBinder().getODataEntitySet(resource)));
                    break block14;
                }
                if (CommonODataEntity.class.isAssignableFrom(reference)) {
                    ResWrap container = this.client.getDeserializer(ODataFormat.fromString((String)format)).toEntity(src);
                    res = new ResWrap(container.getContextURL(), container.getMetadataETag(), reference.cast(this.client.getBinder().getODataEntity(container)));
                    break block14;
                }
                if (CommonODataProperty.class.isAssignableFrom(reference)) {
                    ResWrap container = this.client.getDeserializer(ODataFormat.fromString((String)format)).toProperty(src);
                    res = new ResWrap(container.getContextURL(), container.getMetadataETag(), reference.cast(this.client.getBinder().getODataProperty(container)));
                    break block14;
                }
                if (ODataValue.class.isAssignableFrom(reference)) {
                    res = new ResWrap((URI)null, null, reference.cast(this.client.getObjectFactory().newPrimitiveValueBuilder().setType(ODataFormat.fromString((String)format) == ODataFormat.TEXT_PLAIN ? EdmPrimitiveTypeKind.String : EdmPrimitiveTypeKind.Stream).setValue((Object)IOUtils.toString((InputStream)src)).build()));
                    break block14;
                }
                if (XMLMetadata.class.isAssignableFrom(reference)) {
                    res = new ResWrap((URI)null, null, reference.cast(this.readMetadata(src)));
                    break block14;
                }
                if (ODataServiceDocument.class.isAssignableFrom(reference)) {
                    ResWrap resource = this.client.getDeserializer(ODataFormat.fromString((String)format)).toServiceDocument(src);
                    res = new ResWrap(resource.getContextURL(), resource.getMetadataETag(), reference.cast(this.client.getBinder().getODataServiceDocument((ServiceDocument)resource.getPayload())));
                    break block14;
                }
                if (ODataError.class.isAssignableFrom(reference)) {
                    res = new ResWrap((URI)null, null, reference.cast(this.readError(src, ODataFormat.fromString((String)format))));
                    break block14;
                }
                throw new IllegalArgumentException("Invalid reference type " + reference);
            }
            catch (Exception e) {
                LOG.warn("Cast error", (Throwable)e);
                res = null;
            }
            finally {
                if (!ODataEntitySetIterator.class.isAssignableFrom(reference)) {
                    IOUtils.closeQuietly((InputStream)src);
                }
            }
        }
        return res;
    }
}

