/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.serialization.ODataWriter;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.domain.CommonODataEntity;
import org.apache.olingo.commons.api.domain.CommonODataProperty;
import org.apache.olingo.commons.api.domain.ODataLink;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataSerializerException;

public class ODataWriterImpl
implements ODataWriter {
    protected final CommonODataClient<?> client;

    public ODataWriterImpl(CommonODataClient<?> client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream writeEntities(Collection<CommonODataEntity> entities, ODataFormat format) throws ODataSerializerException {
        OutputStreamWriter writer;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            writer = null;
        }
        try {
            for (CommonODataEntity entity : entities) {
                this.client.getSerializer(format).write((Writer)writer, (Object)this.client.getBinder().getEntity(entity));
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(output.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
    }

    public InputStream writeEntity(CommonODataEntity entity, ODataFormat format) throws ODataSerializerException {
        return this.writeEntities(Collections.singleton(entity), format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream writeProperty(CommonODataProperty property, ODataFormat format) throws ODataSerializerException {
        OutputStreamWriter writer;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            writer = null;
        }
        try {
            this.client.getSerializer(format).write((Writer)writer, (Object)this.client.getBinder().getProperty(property));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(output.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream writeLink(ODataLink link, ODataFormat format) throws ODataSerializerException {
        OutputStreamWriter writer;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            writer = null;
        }
        try {
            this.client.getSerializer(format).write((Writer)writer, (Object)this.client.getBinder().getLink(link));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(output.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream writeReference(ResWrap<URI> reference, ODataFormat format) throws ODataSerializerException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        try {
            this.client.getSerializer(format).write((Writer)writer, reference);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(output.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
    }
}

