/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.uri;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.olingo.client.api.Configuration;
import org.apache.olingo.client.api.uri.CommonURIBuilder;
import org.apache.olingo.client.api.uri.QueryOption;
import org.apache.olingo.client.api.uri.SegmentType;
import org.apache.olingo.client.api.uri.URIFilter;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractURIBuilder<UB extends CommonURIBuilder<?>>
implements CommonURIBuilder<UB> {
    protected static final Logger LOG = LoggerFactory.getLogger(CommonURIBuilder.class);
    private final ODataServiceVersion version;
    private final Configuration configuration;
    protected final List<Segment> segments = new ArrayList<Segment>();
    protected final Map<String, String> queryOptions = new LinkedHashMap<String, String>();
    protected final Map<String, String> parameters = new LinkedHashMap<String, String>();

    protected AbstractURIBuilder(ODataServiceVersion version, Configuration configuration, String serviceRoot) {
        this.version = version;
        this.configuration = configuration;
        this.segments.add(new Segment(SegmentType.SERVICEROOT, serviceRoot));
    }

    protected abstract UB getThis();

    public UB addQueryOption(QueryOption option, String value) {
        return this.addQueryOption(option.toString(), value, false);
    }

    public UB replaceQueryOption(QueryOption option, String value) {
        return this.addQueryOption(option.toString(), value, true);
    }

    public UB addQueryOption(String option, String value, boolean replace) {
        StringBuilder builder = new StringBuilder();
        if (!replace && this.queryOptions.containsKey(option)) {
            builder.append(this.queryOptions.get(option)).append(',');
        }
        builder.append(value);
        this.queryOptions.put(option, builder.toString());
        return this.getThis();
    }

    public UB addParameterAlias(String alias, String exp) {
        this.parameters.put(alias, exp);
        return this.getThis();
    }

    public UB appendEntitySetSegment(String segmentValue) {
        this.segments.add(new Segment(SegmentType.ENTITYSET, segmentValue));
        return this.getThis();
    }

    public UB appendKeySegment(Object val) {
        String segValue = URIUtils.escape(this.version, val);
        this.segments.add(this.configuration.isKeyAsSegment() ? new Segment(SegmentType.KEY_AS_SEGMENT, segValue) : new Segment(SegmentType.KEY, "(" + segValue + ")"));
        return this.getThis();
    }

    protected abstract String noKeysWrapper();

    public UB appendKeySegment(Map<String, Object> segmentValues) {
        if (!this.configuration.isKeyAsSegment()) {
            String key = this.buildMultiKeySegment(segmentValues, true);
            if (StringUtils.isEmpty((CharSequence)key)) {
                this.segments.add(new Segment(SegmentType.KEY, this.noKeysWrapper()));
            } else {
                this.segments.add(new Segment(SegmentType.KEY, key));
            }
        }
        return this.getThis();
    }

    public UB appendPropertySegment(String segmentValue) {
        this.segments.add(new Segment(SegmentType.PROPERTY, segmentValue));
        return this.getThis();
    }

    public UB appendNavigationSegment(String segmentValue) {
        this.segments.add(new Segment(SegmentType.NAVIGATION, segmentValue));
        return this.getThis();
    }

    public UB appendDerivedEntityTypeSegment(String segmentValue) {
        this.segments.add(new Segment(SegmentType.DERIVED_ENTITY_TYPE, segmentValue));
        return this.getThis();
    }

    public UB appendValueSegment() {
        this.segments.add(new Segment(SegmentType.VALUE, SegmentType.VALUE.getValue()));
        return this.getThis();
    }

    public UB appendOperationCallSegment(String operation) {
        this.segments.add(new Segment(this.segments.size() == 1 ? SegmentType.UNBOUND_OPERATION : SegmentType.BOUND_OPERATION, operation));
        return this.getThis();
    }

    public UB appendMetadataSegment() {
        this.segments.add(new Segment(SegmentType.METADATA, SegmentType.METADATA.getValue()));
        return this.getThis();
    }

    public UB appendBatchSegment() {
        this.segments.add(new Segment(SegmentType.BATCH, SegmentType.BATCH.getValue()));
        return this.getThis();
    }

    public UB count() {
        this.segments.add(new Segment(SegmentType.ROOT_QUERY_OPTION, "$" + QueryOption.COUNT.toString()));
        return this.getThis();
    }

    public UB expand(String ... expandItems) {
        return this.addQueryOption(QueryOption.EXPAND, StringUtils.join((Object[])expandItems, (String)","));
    }

    public UB format(String format) {
        return this.replaceQueryOption(QueryOption.FORMAT, format);
    }

    public UB filter(URIFilter filter) {
        UB result;
        try {
            result = this.filter(URLDecoder.decode(filter.build(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            result = this.filter(filter.build());
        }
        return result;
    }

    public UB filter(String filter) {
        return this.replaceQueryOption(QueryOption.FILTER, filter);
    }

    public UB select(String ... selectItems) {
        return this.addQueryOption(QueryOption.SELECT, StringUtils.join((Object[])selectItems, (String)","));
    }

    public UB orderBy(String order) {
        return this.replaceQueryOption(QueryOption.ORDERBY, order);
    }

    public UB top(int top) {
        return this.replaceQueryOption(QueryOption.TOP, String.valueOf(top));
    }

    public UB skip(int skip) {
        return this.replaceQueryOption(QueryOption.SKIP, String.valueOf(skip));
    }

    public UB skipToken(String skipToken) {
        return this.replaceQueryOption(QueryOption.SKIPTOKEN, skipToken);
    }

    protected abstract char getBoundOperationSeparator();

    protected abstract String getOperationInvokeMarker();

    public URI build() {
        StringBuilder segmentsBuilder = new StringBuilder();
        for (Segment seg : this.segments) {
            if (segmentsBuilder.length() > 0 && seg.getType() != SegmentType.KEY) {
                switch (seg.getType()) {
                    case BOUND_OPERATION: {
                        segmentsBuilder.append(this.getBoundOperationSeparator());
                        break;
                    }
                    default: {
                        if (segmentsBuilder.length() <= 0 || segmentsBuilder.charAt(segmentsBuilder.length() - 1) == '/') break;
                        segmentsBuilder.append('/');
                    }
                }
            }
            if (seg.getType() == SegmentType.ENTITY) {
                segmentsBuilder.append(seg.getType().getValue());
            } else {
                segmentsBuilder.append(seg.getValue());
            }
            if (seg.getType() != SegmentType.BOUND_OPERATION && seg.getType() != SegmentType.UNBOUND_OPERATION) continue;
            segmentsBuilder.append(this.getOperationInvokeMarker());
        }
        try {
            StringBuilder sb = segmentsBuilder;
            if (this.queryOptions.size() + this.parameters.size() > 0) {
                sb.append("?");
                LinkedList<BasicNameValuePair> list1 = new LinkedList<BasicNameValuePair>();
                for (Map.Entry<String, String> option : this.queryOptions.entrySet()) {
                    list1.add(new BasicNameValuePair("$" + option.getKey(), option.getValue()));
                }
                for (Map.Entry<String, String> parameter : this.parameters.entrySet()) {
                    list1.add(new BasicNameValuePair("@" + parameter.getKey(), parameter.getValue()));
                }
                String queryStr = URLEncodedUtils.format(list1, (String)"UTF-8");
                sb.append(queryStr);
            }
            return URI.create(sb.toString());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not build valid URI", e);
        }
    }

    public String toString() {
        return this.build().toASCIIString();
    }

    protected String buildMultiKeySegment(Map<String, Object> segmentValues, boolean escape) {
        if (segmentValues == null || segmentValues.isEmpty()) {
            return "";
        }
        StringBuilder keyBuilder = new StringBuilder().append('(');
        for (Map.Entry<String, Object> entry : segmentValues.entrySet()) {
            keyBuilder.append(entry.getKey()).append('=').append(escape ? URIUtils.escape(this.version, entry.getValue()) : entry.getValue());
            keyBuilder.append(',');
        }
        keyBuilder.deleteCharAt(keyBuilder.length() - 1).append(')');
        return keyBuilder.toString();
    }

    protected static class Segment {
        private final SegmentType type;
        private final String value;

        public Segment(SegmentType type, String value) {
            this.type = type;
            this.value = value;
        }

        public SegmentType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }
    }
}

