/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core;

import org.apache.olingo.client.api.Configuration;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.header.HeaderName;
import org.apache.olingo.client.api.communication.header.ODataHeaders;
import org.apache.olingo.client.api.communication.header.ODataPreferences;
import org.apache.olingo.client.api.communication.request.AsyncRequestFactory;
import org.apache.olingo.client.api.communication.request.batch.BatchRequestFactory;
import org.apache.olingo.client.api.communication.request.cud.CUDRequestFactory;
import org.apache.olingo.client.api.communication.request.invoke.InvokeRequestFactory;
import org.apache.olingo.client.api.communication.request.retrieve.RetrieveRequestFactory;
import org.apache.olingo.client.api.domain.ClientObjectFactory;
import org.apache.olingo.client.api.serialization.ClientODataDeserializer;
import org.apache.olingo.client.api.serialization.ODataBinder;
import org.apache.olingo.client.api.serialization.ODataReader;
import org.apache.olingo.client.api.serialization.ODataWriter;
import org.apache.olingo.client.api.uri.FilterFactory;
import org.apache.olingo.client.api.uri.SearchFactory;
import org.apache.olingo.client.api.uri.URIBuilder;
import org.apache.olingo.client.core.ConfigurationImpl;
import org.apache.olingo.client.core.SearchFactoryImpl;
import org.apache.olingo.client.core.communication.header.ODataHeadersImpl;
import org.apache.olingo.client.core.communication.request.AsyncRequestFactoryImpl;
import org.apache.olingo.client.core.communication.request.batch.BatchRequestFactoryImpl;
import org.apache.olingo.client.core.communication.request.cud.CUDRequestFactoryImpl;
import org.apache.olingo.client.core.communication.request.invoke.InvokeRequestFactoryImpl;
import org.apache.olingo.client.core.communication.request.retrieve.RetrieveRequestFactoryImpl;
import org.apache.olingo.client.core.domain.ClientObjectFactoryImpl;
import org.apache.olingo.client.core.serialization.ClientODataDeserializerImpl;
import org.apache.olingo.client.core.serialization.ODataBinderImpl;
import org.apache.olingo.client.core.serialization.ODataReaderImpl;
import org.apache.olingo.client.core.serialization.ODataWriterImpl;
import org.apache.olingo.client.core.uri.FilterFactoryImpl;
import org.apache.olingo.client.core.uri.URIBuilderImpl;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataSerializer;
import org.apache.olingo.commons.core.serialization.AtomSerializer;
import org.apache.olingo.commons.core.serialization.JsonSerializer;

public class ODataClientImpl
implements ODataClient {
    private final FilterFactory filterFactory = new FilterFactoryImpl();
    private final SearchFactory searchFactory = new SearchFactoryImpl();
    private final ODataReader reader = new ODataReaderImpl(this);
    private final ODataBinder binder = new ODataBinderImpl(this);
    private final ClientObjectFactory objectFactory = new ClientObjectFactoryImpl();
    private final AsyncRequestFactory asyncReqFact = new AsyncRequestFactoryImpl(this);
    private final RetrieveRequestFactory retrieveReqFact = new RetrieveRequestFactoryImpl(this);
    private final CUDRequestFactory cudReqFact = new CUDRequestFactoryImpl(this);
    private final InvokeRequestFactory invokeReqFact = new InvokeRequestFactoryImpl(this);
    private final BatchRequestFactory batchReqFact = new BatchRequestFactoryImpl(this);
    protected final Configuration configuration = new ConfigurationImpl();
    private final ODataWriter writer = new ODataWriterImpl(this);

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ODataPreferences newPreferences() {
        return new ODataPreferences();
    }

    public ODataWriter getWriter() {
        return this.writer;
    }

    public ODataServiceVersion getServiceVersion() {
        return ODataServiceVersion.V40;
    }

    public ODataHeaders newVersionHeaders() {
        ODataHeadersImpl odataHeaders = new ODataHeadersImpl();
        odataHeaders.setHeader(HeaderName.odataMaxVersion, ODataServiceVersion.V40.toString());
        odataHeaders.setHeader(HeaderName.odataVersion, ODataServiceVersion.V40.toString());
        return odataHeaders;
    }

    public URIBuilder newURIBuilder(String serviceRoot) {
        return new URIBuilderImpl(this.getConfiguration(), serviceRoot);
    }

    public FilterFactory getFilterFactory() {
        return this.filterFactory;
    }

    public SearchFactory getSearchFactory() {
        return this.searchFactory;
    }

    public ClientODataDeserializer getDeserializer(ODataFormat format) {
        return new ClientODataDeserializerImpl(false, format);
    }

    public ODataSerializer getSerializer(ODataFormat format) {
        return format == ODataFormat.ATOM || format == ODataFormat.XML ? new AtomSerializer() : new JsonSerializer(false, format);
    }

    public ODataReader getReader() {
        return this.reader;
    }

    public ODataBinder getBinder() {
        return this.binder;
    }

    public ClientObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public AsyncRequestFactory getAsyncRequestFactory() {
        return this.asyncReqFact;
    }

    public RetrieveRequestFactory getRetrieveRequestFactory() {
        return this.retrieveReqFact;
    }

    public CUDRequestFactory getCUDRequestFactory() {
        return this.cudReqFact;
    }

    public InvokeRequestFactory getInvokeRequestFactory() {
        return this.invokeReqFact;
    }

    public BatchRequestFactory getBatchRequestFactory() {
        return this.batchReqFact;
    }
}

