/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request;

import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.header.HeaderName;
import org.apache.olingo.client.api.communication.header.ODataPreferences;
import org.apache.olingo.client.api.communication.request.AsyncBatchRequestWrapper;
import org.apache.olingo.client.api.communication.request.ODataBatchableRequest;
import org.apache.olingo.client.api.communication.request.ODataRequest;
import org.apache.olingo.client.api.communication.request.batch.BatchManager;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchRequest;
import org.apache.olingo.client.api.communication.request.batch.ODataChangeset;
import org.apache.olingo.client.api.communication.response.AsyncResponseWrapper;
import org.apache.olingo.client.api.communication.response.ODataBatchResponse;
import org.apache.olingo.client.core.communication.request.AsyncRequestException;
import org.apache.olingo.client.core.communication.request.AsyncRequestWrapperImpl;

public class AsyncBatchRequestWrapperImpl
extends AsyncRequestWrapperImpl<ODataBatchResponse>
implements AsyncBatchRequestWrapper {
    private BatchManager batchManager;

    protected AsyncBatchRequestWrapperImpl(ODataClient odataClient, ODataBatchRequest odataRequest) {
        super(odataClient, (ODataRequest)odataRequest);
        this.batchManager = (BatchManager)odataRequest.payloadManager();
    }

    public ODataChangeset addChangeset() {
        return this.batchManager.addChangeset();
    }

    public void addRetrieve(ODataBatchableRequest request) {
        this.batchManager.addRequest(request);
    }

    public void addOutsideUpdate(ODataBatchableRequest request) {
        this.batchManager.addRequest(request);
    }

    @Override
    public AsyncResponseWrapper<ODataBatchResponse> execute() {
        return new AsyncResponseWrapperImpl((ODataBatchResponse)this.batchManager.getResponse());
    }

    public class AsyncResponseWrapperImpl
    extends AsyncRequestWrapperImpl.AsyncResponseWrapperImpl {
        public AsyncResponseWrapperImpl(ODataBatchResponse res) {
            super(AsyncBatchRequestWrapperImpl.this);
            if (res.getStatusCode() == 202) {
                this.retrieveMonitorDetails(res);
            } else {
                this.response = res;
            }
        }

        private void retrieveMonitorDetails(ODataBatchResponse res) {
            Collection headers = res.getHeader(HeaderName.location.toString());
            if (headers == null || headers.isEmpty()) {
                throw new AsyncRequestException("Invalid async request response. Monitor URL not found");
            }
            this.location = URI.create((String)headers.iterator().next());
            headers = res.getHeader(HeaderName.retryAfter.toString());
            if (headers != null && !headers.isEmpty()) {
                this.retryAfter = Integer.parseInt((String)headers.iterator().next());
            }
            if ((headers = res.getHeader(HeaderName.preferenceApplied.toString())) != null && !headers.isEmpty()) {
                for (String header : headers) {
                    if (!header.equalsIgnoreCase(new ODataPreferences().respondAsync())) continue;
                    this.preferenceApplied = true;
                }
            }
            IOUtils.closeQuietly((InputStream)res.getRawResponse());
        }
    }
}

