/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.batch;

import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.olingo.client.api.ODataBatchConstants;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.client.core.communication.request.batch.AbstractODataBatchResponseItem;
import org.apache.olingo.client.core.communication.request.batch.ODataBatchUtilities;
import org.apache.olingo.client.core.communication.response.AsyncResponseImpl;
import org.apache.olingo.client.core.communication.response.batch.ODataBatchErrorResponse;

public class ODataChangesetResponseItem
extends AbstractODataBatchResponseItem {
    private final boolean continueOnError;
    private boolean unexpected = false;

    public ODataChangesetResponseItem(boolean continueOnError) {
        super(true);
        this.continueOnError = continueOnError;
    }

    public void setUnexpected() {
        this.unexpected = true;
    }

    public ODataResponse next() {
        if (this.current != null) {
            this.current.close();
        }
        if (this.closed) {
            throw new IllegalStateException("Invalid request - the item has been closed");
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException("No item found");
        }
        if (this.unexpected) {
            this.breaking = true;
            return this.nextUnexpected();
        }
        return this.nextExpected();
    }

    private ODataResponse nextExpected() {
        this.expectedItemsIterator.next();
        Map<String, Collection<String>> nextItemHeaders = ODataBatchUtilities.nextItemHeaders(this.batchLineIterator, this.boundary);
        if (nextItemHeaders.isEmpty()) {
            throw new IllegalStateException("Expected item not found");
        }
        Map.Entry<Integer, String> responseLine = ODataBatchUtilities.readResponseLine(this.batchLineIterator);
        LOG.debug("Retrieved item response {}", responseLine);
        Map<String, Collection<String>> headers = ODataBatchUtilities.readHeaders(this.batchLineIterator);
        LOG.debug("Retrieved item headers {}", headers);
        Collection<String> contentId = nextItemHeaders.get(ODataBatchConstants.CHANGESET_CONTENT_ID_NAME);
        if ((contentId == null || contentId.isEmpty()) && ((contentId = headers.get(ODataBatchConstants.CHANGESET_CONTENT_ID_NAME)) == null || contentId.isEmpty())) {
            throw new IllegalStateException("Content-ID is missing");
        }
        this.current = this.getResponse(contentId.iterator().next());
        if (this.current == null) {
            throw new IllegalStateException("Unexpected '" + contentId + "' item found");
        }
        this.current.initFromBatch(responseLine, headers, this.batchLineIterator, this.boundary);
        if (this.current.getStatusCode() >= 400 && !this.continueOnError) {
            this.breaking = true;
        }
        return this.current;
    }

    private ODataResponse nextUnexpected() {
        Map.Entry<Integer, String> responseLine = ODataBatchUtilities.readResponseLine(this.batchLineIterator);
        LOG.debug("Retrieved item response {}", responseLine);
        Map<String, Collection<String>> headers = ODataBatchUtilities.readHeaders(this.batchLineIterator);
        LOG.debug("Retrieved item headers {}", headers);
        if (responseLine.getKey() == 202) {
            this.current = new AsyncResponseImpl(responseLine, headers, this.batchLineIterator, this.boundary);
            return this.current;
        }
        if (responseLine.getKey() >= 400) {
            this.current = new ODataBatchErrorResponse(responseLine, headers, this.batchLineIterator, this.boundary);
            return this.current;
        }
        throw new IllegalStateException("Expected item not found");
    }

    public void remove() {
        throw new UnsupportedOperationException("Not supported operation.");
    }
}

