/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.cud;

import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.cud.ODataEntityCreateRequest;
import org.apache.olingo.client.api.communication.response.ODataEntityCreateResponse;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.core.communication.request.AbstractODataBasicRequest;
import org.apache.olingo.client.core.communication.response.AbstractODataResponse;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;
import org.apache.olingo.commons.api.serialization.ODataSerializerException;

public class ODataEntityCreateRequestImpl<E extends ClientEntity>
extends AbstractODataBasicRequest<ODataEntityCreateResponse<E>>
implements ODataEntityCreateRequest<E> {
    private final E entity;

    ODataEntityCreateRequestImpl(ODataClient odataClient, URI targetURI, E entity) {
        super(odataClient, HttpMethod.POST, targetURI);
        this.entity = entity;
    }

    @Override
    public ODataFormat getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultPubFormat();
    }

    @Override
    protected InputStream getPayload() {
        try {
            return this.odataClient.getWriter().writeEntity(this.entity, ODataFormat.fromString((String)this.getContentType()));
        }
        catch (ODataSerializerException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataEntityCreateResponse<E> execute() {
        InputStream input = this.getPayload();
        ((HttpPost)this.request).setEntity(URIUtils.buildInputStreamEntity(this.odataClient, input));
        try {
            ODataEntityCreateResponseImpl oDataEntityCreateResponseImpl = new ODataEntityCreateResponseImpl(this.odataClient, this.httpClient, this.doExecute());
            return oDataEntityCreateResponseImpl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    private class ODataEntityCreateResponseImpl
    extends AbstractODataResponse
    implements ODataEntityCreateResponse<E> {
        private E resEntity;

        private ODataEntityCreateResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.resEntity = null;
        }

        public E getBody() {
            if (this.resEntity == null) {
                try {
                    ResWrap resource = this.odataClient.getDeserializer(ODataFormat.fromString((String)ODataEntityCreateRequestImpl.this.getAccept())).toEntity(this.getRawResponse());
                    this.resEntity = this.odataClient.getBinder().getODataEntity(resource);
                }
                catch (ODataDeserializerException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            return this.resEntity;
        }
    }
}

