/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.invoke;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.ODataBatchableRequest;
import org.apache.olingo.client.api.communication.request.invoke.ClientNoContent;
import org.apache.olingo.client.api.communication.request.invoke.ODataInvokeRequest;
import org.apache.olingo.client.api.communication.response.ODataInvokeResponse;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientEntitySet;
import org.apache.olingo.client.api.domain.ClientInvokeResult;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.client.api.domain.ClientValue;
import org.apache.olingo.client.api.http.HttpClientException;
import org.apache.olingo.client.core.communication.request.AbstractODataBasicRequest;
import org.apache.olingo.client.core.communication.response.AbstractODataResponse;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;
import org.apache.olingo.commons.api.serialization.ODataSerializerException;

public abstract class AbstractODataInvokeRequest<T extends ClientInvokeResult>
extends AbstractODataBasicRequest<ODataInvokeResponse<T>>
implements ODataInvokeRequest<T>,
ODataBatchableRequest {
    private final Class<T> reference;
    protected Map<String, ClientValue> parameters;

    public AbstractODataInvokeRequest(ODataClient odataClient, Class<T> reference, HttpMethod method, URI uri) {
        super(odataClient, method, uri);
        this.reference = reference;
        this.parameters = new LinkedHashMap<String, ClientValue>();
    }

    public void setParameters(Map<String, ClientValue> parameters) {
        this.parameters.clear();
        if (parameters != null && !parameters.isEmpty()) {
            this.parameters.putAll(parameters);
        }
    }

    @Override
    public ODataFormat getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultPubFormat();
    }

    private String getActualFormat(ODataFormat format) {
        return (ClientProperty.class.isAssignableFrom(this.reference) && format == ODataFormat.ATOM ? ODataFormat.XML : format).getContentType().toContentTypeString();
    }

    @Override
    public void setFormat(ODataFormat format) {
        String _format = this.getActualFormat(format);
        this.setAccept(_format);
        this.setContentType(_format);
    }

    protected abstract ODataFormat getPOSTParameterFormat();

    @Override
    protected InputStream getPayload() {
        if (!this.parameters.isEmpty() && this.method == HttpMethod.POST) {
            ClientEntity tmp = this.odataClient.getObjectFactory().newEntity(null);
            for (Map.Entry<String, ClientValue> param : this.parameters.entrySet()) {
                ClientProperty property = null;
                if (param.getValue().isPrimitive()) {
                    property = this.odataClient.getObjectFactory().newPrimitiveProperty(param.getKey(), param.getValue().asPrimitive());
                } else if (param.getValue().isComplex()) {
                    property = this.odataClient.getObjectFactory().newComplexProperty(param.getKey(), param.getValue().asComplex());
                } else if (param.getValue().isCollection()) {
                    property = this.odataClient.getObjectFactory().newCollectionProperty(param.getKey(), param.getValue().asCollection());
                } else if (param.getValue().isEnum()) {
                    property = this.odataClient.getObjectFactory().newEnumProperty(param.getKey(), param.getValue().asEnum());
                }
                if (property == null) continue;
                this.odataClient.getBinder().add(tmp, property);
            }
            try {
                return this.odataClient.getWriter().writeEntity(tmp, this.getPOSTParameterFormat());
            }
            catch (ODataSerializerException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataInvokeResponse<T> execute() {
        InputStream input = this.getPayload();
        if (!this.parameters.isEmpty()) {
            if (this.method == HttpMethod.GET) {
                ((HttpRequestBase)this.request).setURI(URIUtils.buildFunctionInvokeURI(this.uri, this.parameters));
            } else if (this.method == HttpMethod.POST) {
                ((HttpPost)this.request).setEntity(URIUtils.buildInputStreamEntity(this.odataClient, input));
                this.setContentType(this.getActualFormat(this.getPOSTParameterFormat()));
            }
        }
        try {
            ODataInvokeResponseImpl oDataInvokeResponseImpl = new ODataInvokeResponseImpl(this.odataClient, this.httpClient, this.doExecute());
            return oDataInvokeResponseImpl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    protected class ODataInvokeResponseImpl
    extends AbstractODataResponse
    implements ODataInvokeResponse<T> {
        private T invokeResult;

        private ODataInvokeResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.invokeResult = null;
        }

        public T getBody() {
            if (this.invokeResult == null) {
                try {
                    if (ClientNoContent.class.isAssignableFrom(AbstractODataInvokeRequest.this.reference)) {
                        this.invokeResult = (ClientInvokeResult)AbstractODataInvokeRequest.this.reference.cast(new ClientNoContent());
                    } else {
                        InputStream responseStream;
                        InputStream inputStream = responseStream = this.payload == null ? this.res.getEntity().getContent() : this.payload;
                        if (ClientEntitySet.class.isAssignableFrom(AbstractODataInvokeRequest.this.reference)) {
                            this.invokeResult = (ClientInvokeResult)AbstractODataInvokeRequest.this.reference.cast(this.odataClient.getReader().readEntitySet(responseStream, ODataFormat.fromString((String)this.getContentType())));
                        } else if (ClientEntity.class.isAssignableFrom(AbstractODataInvokeRequest.this.reference)) {
                            this.invokeResult = (ClientInvokeResult)AbstractODataInvokeRequest.this.reference.cast(this.odataClient.getReader().readEntity(responseStream, ODataFormat.fromString((String)this.getContentType())));
                        } else if (ClientProperty.class.isAssignableFrom(AbstractODataInvokeRequest.this.reference)) {
                            this.invokeResult = (ClientInvokeResult)AbstractODataInvokeRequest.this.reference.cast(this.odataClient.getReader().readProperty(responseStream, ODataFormat.fromString((String)this.getContentType())));
                        }
                    }
                }
                catch (IOException e) {
                    throw new HttpClientException((Throwable)e);
                }
                catch (ODataDeserializerException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            return this.invokeResult;
        }
    }
}

