/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve;

import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.ODataDeltaRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.domain.ClientDelta;
import org.apache.olingo.client.api.http.HttpClientException;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractODataRetrieveRequest;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;

public class ODataDeltaRequestImpl
extends AbstractODataRetrieveRequest<ClientDelta>
implements ODataDeltaRequest {
    public ODataDeltaRequestImpl(ODataClient odataClient, URI query) {
        super(odataClient, query);
    }

    @Override
    public ODataFormat getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultPubFormat();
    }

    @Override
    public ODataRetrieveResponse<ClientDelta> execute() {
        HttpResponse res = this.doExecute();
        return new ODataDeltaResponseImpl(this.odataClient, this.httpClient, res);
    }

    protected class ODataDeltaResponseImpl
    extends AbstractODataRetrieveRequest.AbstractODataRetrieveResponse {
        private ClientDelta delta;

        private ODataDeltaResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.delta = null;
        }

        public ClientDelta getBody() {
            if (this.delta == null) {
                try {
                    ResWrap resource = this.odataClient.getDeserializer(ODataFormat.fromString((String)this.getContentType())).toDelta(this.res.getEntity().getContent());
                    this.delta = this.odataClient.getBinder().getODataDelta(resource);
                }
                catch (IOException e) {
                    throw new HttpClientException((Throwable)e);
                }
                catch (ODataDeserializerException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            return this.delta;
        }
    }
}

