/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve;

import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.ODataEntitySetRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.domain.ClientEntitySet;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractODataRetrieveRequest;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;

public class ODataEntitySetRequestImpl<ES extends ClientEntitySet>
extends AbstractODataRetrieveRequest<ES>
implements ODataEntitySetRequest<ES> {
    private ES entitySet = null;

    public ODataEntitySetRequestImpl(ODataClient odataClient, URI query) {
        super(odataClient, query);
    }

    @Override
    public ODataFormat getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultPubFormat();
    }

    @Override
    public ODataRetrieveResponse<ES> execute() {
        HttpResponse res = this.doExecute();
        return new ODataEntitySetResponseImpl(this.odataClient, this.httpClient, res);
    }

    protected class ODataEntitySetResponseImpl
    extends AbstractODataRetrieveRequest.AbstractODataRetrieveResponse {
        private ODataEntitySetResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
        }

        public ES getBody() {
            if (ODataEntitySetRequestImpl.this.entitySet == null) {
                try {
                    ResWrap resource = this.odataClient.getDeserializer(ODataFormat.fromString((String)this.getContentType())).toEntitySet(this.getRawResponse());
                    ODataEntitySetRequestImpl.this.entitySet = this.odataClient.getBinder().getODataEntitySet(resource);
                }
                catch (ODataDeserializerException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            return ODataEntitySetRequestImpl.this.entitySet;
        }
    }
}

