/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.ODataMediaRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.http.HttpClientException;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractODataRetrieveRequest;
import org.apache.olingo.commons.api.format.ODataFormat;

public class ODataMediaRequestImpl
extends AbstractODataRetrieveRequest<InputStream>
implements ODataMediaRequest {
    ODataMediaRequestImpl(ODataClient odataClient, URI query) {
        super(odataClient, query);
        this.setAccept(ODataFormat.APPLICATION_OCTET_STREAM.toString());
        this.setContentType(ODataFormat.APPLICATION_OCTET_STREAM.toString());
    }

    @Override
    public ODataFormat getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultMediaFormat();
    }

    @Override
    public ODataRetrieveResponse<InputStream> execute() {
        HttpResponse res = this.doExecute();
        return new ODataMediaResponseImpl(this.odataClient, this.httpClient, res);
    }

    protected class ODataMediaResponseImpl
    extends AbstractODataRetrieveRequest.AbstractODataRetrieveResponse {
        private InputStream input;

        private ODataMediaResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.input = null;
        }

        public InputStream getBody() {
            if (this.input == null) {
                try {
                    this.input = this.res.getEntity().getContent();
                }
                catch (IOException e) {
                    throw new HttpClientException((Throwable)e);
                }
            }
            return this.input;
        }
    }
}

