/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve;

import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.ODataValueRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.domain.ClientPrimitiveValue;
import org.apache.olingo.client.api.http.HttpClientException;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractODataRetrieveRequest;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.format.ODataFormat;

public class ODataValueRequestImpl
extends AbstractODataRetrieveRequest<ClientPrimitiveValue>
implements ODataValueRequest {
    ODataValueRequestImpl(ODataClient odataClient, URI query) {
        super(odataClient, query);
    }

    @Override
    public ODataFormat getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultValueFormat();
    }

    @Override
    public ODataRetrieveResponse<ClientPrimitiveValue> execute() {
        HttpResponse res = this.doExecute();
        return new ODataValueResponseImpl(this.odataClient, this.httpClient, res);
    }

    protected class ODataValueResponseImpl
    extends AbstractODataRetrieveRequest.AbstractODataRetrieveResponse {
        private ClientPrimitiveValue value;

        private ODataValueResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.value = null;
        }

        public ClientPrimitiveValue getBody() {
            if (this.value == null) {
                ODataFormat format = ODataFormat.fromString((String)this.getContentType());
                try {
                    this.value = this.odataClient.getObjectFactory().newPrimitiveValueBuilder().setType(format == ODataFormat.TEXT_PLAIN ? EdmPrimitiveTypeKind.String : EdmPrimitiveTypeKind.Stream).setValue((Object)IOUtils.toString((InputStream)this.getRawResponse())).build();
                }
                catch (Exception e) {
                    throw new HttpClientException((Throwable)e);
                }
                finally {
                    this.close();
                }
            }
            return this.value;
        }
    }
}

