/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve;

import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.XMLMetadataRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.edm.xml.Include;
import org.apache.olingo.client.api.edm.xml.Reference;
import org.apache.olingo.client.api.edm.xml.XMLMetadata;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractMetadataRequestImpl;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractODataRetrieveRequest;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotations;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.format.ODataFormat;

public class XMLMetadataRequestImpl
extends AbstractMetadataRequestImpl<XMLMetadata>
implements XMLMetadataRequest {
    XMLMetadataRequestImpl(ODataClient odataClient, URI uri) {
        super(odataClient, uri);
    }

    @Override
    public ODataRetrieveResponse<XMLMetadata> execute() {
        SingleXMLMetadatRequestImpl rootReq = new SingleXMLMetadatRequestImpl(this.odataClient, this.uri, null);
        ODataRetrieveResponse<XMLMetadata> rootRes = rootReq.execute();
        XMLMetadataResponseImpl response = new XMLMetadataResponseImpl(this.odataClient, this.httpClient, rootReq.getHttpResponse(), (XMLMetadata)rootRes.getBody());
        for (Reference reference : ((XMLMetadata)rootRes.getBody()).getReferences()) {
            SingleXMLMetadatRequestImpl includeReq = new SingleXMLMetadatRequestImpl(this.odataClient, this.odataClient.newURIBuilder(this.uri.resolve(reference.getUri()).toASCIIString()).build(), this.uri);
            XMLMetadata includeMetadata = (XMLMetadata)includeReq.execute().getBody();
            for (Include include : reference.getIncludes()) {
                CsdlSchema includedSchema = includeMetadata.getSchema(include.getNamespace());
                if (includedSchema == null) continue;
                response.getBody().getSchemas().add(includedSchema);
                if (!StringUtils.isNotBlank((CharSequence)include.getAlias())) continue;
                includedSchema.setAlias(include.getAlias());
            }
            for (Include include : reference.getIncludeAnnotations()) {
                for (CsdlSchema schema : includeMetadata.getSchemas()) {
                    CsdlSchema forInclusion = new CsdlSchema();
                    forInclusion.setNamespace(schema.getNamespace());
                    forInclusion.setAlias(schema.getAlias());
                    for (CsdlAnnotations annotationGroup : schema.getAnnotationGroups()) {
                        if (!StringUtils.isBlank((CharSequence)include.getTargetNamespace()) && !include.getTargetNamespace().equals(StringUtils.substringBeforeLast((String)annotationGroup.getTarget(), (String)".")) || !StringUtils.isBlank((CharSequence)include.getQualifier()) && !include.getQualifier().equals(annotationGroup.getQualifier())) continue;
                        CsdlAnnotations toBeIncluded = new CsdlAnnotations();
                        toBeIncluded.setTarget(annotationGroup.getTarget());
                        toBeIncluded.setQualifier(annotationGroup.getQualifier());
                        for (CsdlAnnotation annotation : annotationGroup.getAnnotations()) {
                            if (!include.getTermNamespace().equals(StringUtils.substringBeforeLast((String)annotation.getTerm(), (String)"."))) continue;
                            toBeIncluded.getAnnotations().add(annotation);
                        }
                        forInclusion.getAnnotationGroups().add(toBeIncluded);
                    }
                    if (forInclusion.getAnnotationGroups().isEmpty()) continue;
                    response.getBody().getSchemas().add(forInclusion);
                }
            }
        }
        return response;
    }

    private class XMLMetadataResponseImpl
    extends AbstractODataRetrieveRequest.AbstractODataRetrieveResponse {
        private final XMLMetadata metadata;

        private XMLMetadataResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res, XMLMetadata metadata) {
            super(odataClient, httpClient, null);
            this.metadata = metadata;
            this.statusCode = res.getStatusLine().getStatusCode();
            this.statusMessage = res.getStatusLine().getReasonPhrase();
            this.hasBeenInitialized = true;
        }

        public XMLMetadata getBody() {
            return this.metadata;
        }
    }

    private class SingleXMLMetadatRequestImpl
    extends AbstractMetadataRequestImpl<XMLMetadata> {
        private final URI parentURI;
        private HttpResponse httpResponse;

        public SingleXMLMetadatRequestImpl(ODataClient odataClient, URI uri, URI parent) {
            super(odataClient, uri);
            this.parentURI = parent;
        }

        public HttpResponse getHttpResponse() {
            return this.httpResponse;
        }

        @Override
        protected void checkRequest(ODataClient odataClient, HttpUriRequest request) {
            if (this.parentURI == null) {
                super.checkRequest(odataClient, request);
            } else if (!this.parentURI.getScheme().equals(this.uri.getScheme()) || !this.parentURI.getAuthority().equals(this.uri.getAuthority())) {
                throw new IllegalArgumentException(String.format("The referenced EDMX document has the URI '%s' where scheme, host, or port is different from the main metadata document URI '%s'.", this.uri.toASCIIString(), this.parentURI.toASCIIString()));
            }
        }

        @Override
        public ODataRetrieveResponse<XMLMetadata> execute() {
            this.httpResponse = this.doExecute();
            return new AbstractODataRetrieveRequest.AbstractODataRetrieveResponse(this.odataClient, this.httpClient, this.httpResponse){
                private XMLMetadata metadata;
                {
                    this.metadata = null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public XMLMetadata getBody() {
                    if (this.metadata == null) {
                        try {
                            this.metadata = this.odataClient.getDeserializer(ODataFormat.XML).toMetadata(this.getRawResponse());
                        }
                        finally {
                            this.close();
                        }
                    }
                    return this.metadata;
                }
            };
        }
    }
}

